/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.artemis.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMAcceptorFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptorFactory;
import org.apache.activemq.artemis.core.server.embedded.EmbeddedActiveMQ;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.eclipse.hawk.service.artemis.server.ArtemisServerPlugin;
import org.eclipse.hawk.service.artemis.server.ShiroRealmSecurityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server {
    private static final String SECURITY_ENABLED_PROPERTY = "artemis.security.enabled";
    private static final Logger LOGGER = LoggerFactory.getLogger(Server.class);
    private final String host;
    private final int port;
    private boolean listenToAllInterfaces = false;
    private boolean isSSLEnabled = false;
    private EmbeddedActiveMQ server;

    public Server(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public boolean isListenOnAllInterfaces() {
        return this.listenToAllInterfaces;
    }

    public void setListenOnAllInterfaces(boolean listenOnAllInterfaces) {
        this.listenToAllInterfaces = listenOnAllInterfaces;
    }

    public boolean isSSLEnabled() {
        return this.isSSLEnabled;
    }

    public void setSSLEnabled(boolean sslEnabled) {
        this.isSSLEnabled = sslEnabled;
    }

    public void start() throws Exception {
        if (this.server != null) {
            return;
        }
        LOGGER.info("Artemis server starting...");
        ConfigurationImpl config = new ConfigurationImpl();
        String sSecurityEnabled = System.getProperty(SECURITY_ENABLED_PROPERTY);
        boolean securityEnabled = false;
        if (sSecurityEnabled != null) {
            securityEnabled = Boolean.valueOf(sSecurityEnabled);
        }
        config.setSecurityEnabled(securityEnabled);
        HashSet<TransportConfiguration> transports = new HashSet<TransportConfiguration>();
        transports.add(new TransportConfiguration(InVMAcceptorFactory.class.getName()));
        FluidMap<String, Object> nettyOptions = new FluidMap<String, String>().with("host", this.listenToAllInterfaces ? "0.0.0.0" : this.host).with("port", String.valueOf(this.port)).with("protocols", "CORE,STOMP").with("sslEnabled", String.valueOf(this.isSSLEnabled)).with("useNio", "true");
        if (this.isSSLEnabled) {
            this.putFromProperties(nettyOptions, "org.apache.activemq.ssl.keyStoreProvider", null, "keyStoreProvider");
            this.putFromProperties(nettyOptions, "org.apache.activemq.ssl.keyStore", "javax.net.ssl.keyStore", "keyStorePath");
            this.putFromProperties(nettyOptions, "org.apache.activemq.ssl.keyStorePassword", "javax.net.ssl.keyStorePassword", "keyStorePassword");
            if (nettyOptions.containsKey("keyStorePath") && !nettyOptions.containsKey("keyStorePassword")) {
                System.out.print("\nkeyStorePassword : ");
                nettyOptions.put("keyStorePassword", this.readPassword());
            }
            this.putFromProperties(nettyOptions, "org.apache.activemq.ssl.trustStoreProvider", null, "trustStoreProvider");
            this.putFromProperties(nettyOptions, "org.apache.activemq.ssl.trustStore", "javax.net.ssl.trustStore", "trustStorePath");
            this.putFromProperties(nettyOptions, "org.apache.activemq.ssl.trustStorePassword", "javax.net.ssl.trustStorePassword", "trustStorePassword");
            if (nettyOptions.containsKey("trustStorePath") && !nettyOptions.containsKey("trustStorePassword")) {
                System.out.print("\ntrustStorePassword : ");
                nettyOptions.put("trustStorePassword", this.readPassword());
            }
        }
        transports.add(new TransportConfiguration(NettyAcceptorFactory.class.getName(), nettyOptions));
        config.setAcceptorConfigurations(transports);
        config.setPagingDirectory(this.createArtemisFolder("paging").getAbsolutePath());
        config.setBindingsDirectory(this.createArtemisFolder("bindings").getAbsolutePath());
        config.setJournalDirectory(this.createArtemisFolder("journal").getAbsolutePath());
        config.setLargeMessagesDirectory(this.createArtemisFolder("largemsg").getAbsolutePath());
        AddressSettings defaultAddressSettings = new AddressSettings();
        defaultAddressSettings.setMaxSizeBytes(100000000L);
        defaultAddressSettings.setRedeliveryDelay(2000L);
        defaultAddressSettings.setRedeliveryMultiplier(1.5);
        defaultAddressSettings.setMaxRedeliveryDelay(30000L);
        config.addAddressesSetting("#", defaultAddressSettings);
        this.server = new EmbeddedActiveMQ();
        this.server.setConfiguration((Configuration)config);
        this.server.setSecurityManager((ActiveMQSecurityManager)new ShiroRealmSecurityManager());
        this.server.start();
        LOGGER.info("Artemis server started");
    }

    private String readPassword() throws IOException {
        if (System.console() != null) {
            return new String(System.console().readPassword());
        }
        InputStream in = System.in;
        int max = 50;
        byte[] b = new byte[50];
        int l = in.read(b);
        if (--l > 0) {
            byte[] e = new byte[l];
            System.arraycopy(b, 0, e, 0, l);
            return new String(e);
        }
        return null;
    }

    protected void putFromProperties(Map<String, Object> nettyOptions, String amqPropertyName, String javaPropertyName, String optionName) {
        String value = System.getProperty(amqPropertyName);
        if (value == null && javaPropertyName != null) {
            value = System.getProperty(javaPropertyName);
        }
        if (value != null) {
            nettyOptions.put(optionName, value);
        }
    }

    protected File createArtemisFolder(String folderSuffix) {
        File dataFile = new File(ArtemisServerPlugin.getInstance().getStateLocation().toFile(), "artemis-" + folderSuffix);
        if (!dataFile.exists()) {
            dataFile.mkdir();
            LOGGER.info("Created Artemis paging directory in '{}'", (Object)dataFile.getPath());
        } else {
            LOGGER.info("Reused Artemis paging directory in '{}'", (Object)dataFile.getPath());
        }
        return dataFile;
    }

    public void stop() throws Exception {
        if (this.server == null) {
            return;
        }
        LOGGER.info("Artemis server stopping...");
        this.server.stop();
        this.server = null;
        LOGGER.info("Artemis server stopped");
    }

    public boolean isRunning() {
        return this.server != null;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    private class FluidMap<K, V>
    extends HashMap<K, V> {
        private static final long serialVersionUID = 1L;

        private FluidMap() {
        }

        public FluidMap<K, V> with(K key, V value) {
            this.put(key, value);
            return this;
        }
    }
}

