/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.netty.runtime.graal;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http2.CompressorHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Exception;
import java.util.function.BooleanSupplier;

public class HttpContentCompressorSubstitutions {

    public static class IsBrotliAbsent
    implements BooleanSupplier {
        private boolean brotliAbsent;

        public IsBrotliAbsent() {
            try {
                Class.forName("com.aayushatharva.brotli4j.encoder.Encoder");
                this.brotliAbsent = false;
            }
            catch (ClassNotFoundException e) {
                this.brotliAbsent = true;
            }
        }

        @Override
        public boolean getAsBoolean() {
            return this.brotliAbsent;
        }
    }

    public static class IsZstdAbsent
    implements BooleanSupplier {
        private boolean zstdAbsent;

        public IsZstdAbsent() {
            try {
                Class.forName("com.github.luben.zstd.Zstd");
                this.zstdAbsent = false;
            }
            catch (ClassNotFoundException e) {
                this.zstdAbsent = true;
            }
        }

        @Override
        public boolean getAsBoolean() {
            return this.zstdAbsent;
        }
    }

    @TargetClass(value=CompressorHttp2ConnectionEncoder.class)
    public static final class CompressorHttp2ConnectionSubstitute {
        @Substitute
        protected EmbeddedChannel newContentCompressor(ChannelHandlerContext ctx, CharSequence contentEncoding) throws Http2Exception {
            if (HttpHeaderValues.GZIP.contentEqualsIgnoreCase(contentEncoding) || HttpHeaderValues.X_GZIP.contentEqualsIgnoreCase(contentEncoding)) {
                return this.newCompressionChannel(ctx, ZlibWrapper.GZIP);
            }
            if (HttpHeaderValues.DEFLATE.contentEqualsIgnoreCase(contentEncoding) || HttpHeaderValues.X_DEFLATE.contentEqualsIgnoreCase(contentEncoding)) {
                return this.newCompressionChannel(ctx, ZlibWrapper.ZLIB);
            }
            return null;
        }

        @Alias
        private EmbeddedChannel newCompressionChannel(ChannelHandlerContext ctx, ZlibWrapper wrapper) {
            throw new UnsupportedOperationException();
        }
    }

    @TargetClass(className="io.netty.handler.codec.compression.BrotliEncoder", onlyWith={IsBrotliAbsent.class})
    public static final class BrEncoderFactorySubstitution {
        @Substitute
        protected ByteBuf allocateBuffer(ChannelHandlerContext ctx, ByteBuf msg, boolean preferDirect) throws Exception {
            throw new UnsupportedOperationException();
        }

        @Substitute
        protected void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) {
            throw new UnsupportedOperationException();
        }
    }

    @TargetClass(className="io.netty.handler.codec.compression.ZstdEncoder", onlyWith={IsZstdAbsent.class})
    public static final class ZstdEncoderFactorySubstitution {
        @Substitute
        protected ByteBuf allocateBuffer(ChannelHandlerContext ctx, ByteBuf msg, boolean preferDirect) throws Exception {
            throw new UnsupportedOperationException();
        }

        @Substitute
        protected void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) {
            throw new UnsupportedOperationException();
        }

        @Substitute
        public void flush(ChannelHandlerContext ctx) {
            throw new UnsupportedOperationException();
        }
    }
}

