/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicy;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyFluent;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyFluentImpl;

public class NetworkPolicyBuilder
extends NetworkPolicyFluentImpl<NetworkPolicyBuilder>
implements VisitableBuilder<NetworkPolicy, NetworkPolicyBuilder> {
    NetworkPolicyFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkPolicyBuilder() {
        this(false);
    }

    public NetworkPolicyBuilder(Boolean validationEnabled) {
        this(new NetworkPolicy(), validationEnabled);
    }

    public NetworkPolicyBuilder(NetworkPolicyFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public NetworkPolicyBuilder(NetworkPolicyFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NetworkPolicy(), validationEnabled);
    }

    public NetworkPolicyBuilder(NetworkPolicyFluent<?> fluent, NetworkPolicy instance) {
        this(fluent, instance, false);
    }

    public NetworkPolicyBuilder(NetworkPolicyFluent<?> fluent, NetworkPolicy instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withApiVersion(instance.getApiVersion());
            fluent.withKind(instance.getKind());
            fluent.withMetadata(instance.getMetadata());
            fluent.withSpec(instance.getSpec());
            fluent.withStatus(instance.getStatus());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public NetworkPolicyBuilder(NetworkPolicy instance) {
        this(instance, (Boolean)false);
    }

    public NetworkPolicyBuilder(NetworkPolicy instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public NetworkPolicy build() {
        NetworkPolicy buildable = new NetworkPolicy(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

