/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.runtime;

import io.quarkus.arc.CurrentContextFactory;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ProfileManager;
import io.quarkus.vertx.ConsumeEvent;
import io.quarkus.vertx.LocalEventBusCodec;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.quarkus.vertx.runtime.EventConsumerInvoker;
import io.quarkus.vertx.runtime.VertxCurrentContextFactory;
import io.quarkus.vertx.runtime.VertxProducer;
import io.quarkus.virtual.threads.VirtualThreadsRecorder;
import io.smallrye.common.expression.Expression;
import io.smallrye.common.expression.ResolveContext;
import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.jboss.logging.Logger;

@Recorder
public class VertxEventBusConsumerRecorder {
    private static final Logger LOGGER = Logger.getLogger(VertxEventBusConsumerRecorder.class.getName());
    static volatile Vertx vertx;
    static volatile List<MessageConsumer<?>> messageConsumers;

    public void configureVertx(Supplier<Vertx> vertx, Map<String, ConsumeEvent> messageConsumerConfigurations, LaunchMode launchMode, ShutdownContext shutdown, Map<Class<?>, Class<?>> codecByClass, List<Class<?>> selectorTypes) {
        VertxEventBusConsumerRecorder.vertx = vertx.get();
        messageConsumers = new CopyOnWriteArrayList();
        this.registerMessageConsumers(messageConsumerConfigurations);
        this.registerCodecs(codecByClass, selectorTypes);
        if (launchMode == LaunchMode.DEVELOPMENT) {
            shutdown.addShutdownTask(new Runnable(){

                @Override
                public void run() {
                    VertxEventBusConsumerRecorder.this.unregisterMessageConsumers();
                }
            });
        } else {
            shutdown.addShutdownTask(new Runnable(){

                @Override
                public void run() {
                    VertxEventBusConsumerRecorder.this.destroy();
                }
            });
        }
    }

    public RuntimeValue<CurrentContextFactory> currentContextFactory() {
        return new RuntimeValue<CurrentContextFactory>(new VertxCurrentContextFactory());
    }

    public static Vertx getVertx() {
        return vertx;
    }

    void destroy() {
        messageConsumers = null;
        vertx = null;
    }

    void registerMessageConsumers(Map<String, ConsumeEvent> messageConsumerConfigurations) {
        if (!messageConsumerConfigurations.isEmpty()) {
            final EventBus eventBus = vertx.eventBus();
            VertxInternal vi = (VertxInternal)vertx;
            final CountDownLatch latch = new CountDownLatch(messageConsumerConfigurations.size());
            final ArrayList registrationFailures = new ArrayList();
            for (final Map.Entry<String, ConsumeEvent> entry : messageConsumerConfigurations.entrySet()) {
                final EventConsumerInvoker invoker = this.createInvoker(entry.getKey());
                final String address = VertxEventBusConsumerRecorder.lookUpPropertyValue(entry.getValue().value());
                final ContextInternal context = vi.createEventLoopContext();
                context.runOnContext(new Handler<Void>(){

                    @Override
                    public void handle(Void x) {
                        MessageConsumer consumer = ((ConsumeEvent)entry.getValue()).local() ? eventBus.localConsumer(address) : eventBus.consumer(address);
                        consumer.handler(new Handler<Message<Object>>(){

                            @Override
                            public void handle(final Message<Object> m) {
                                if (invoker.isBlocking()) {
                                    Context dup = VertxContext.getOrCreateDuplicatedContext(context);
                                    VertxContextSafetyToggle.setContextSafe(dup, true);
                                    if (invoker.isRunningOnVirtualThread()) {
                                        dup.runOnContext(new Handler<Void>(){

                                            @Override
                                            public void handle(Void event) {
                                                VirtualThreadsRecorder.getCurrent().execute(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        try {
                                                            invoker.invoke(m);
                                                        }
                                                        catch (Exception e) {
                                                            if (m.replyAddress() == null) {
                                                                throw VertxEventBusConsumerRecorder.wrapIfNecessary(e);
                                                            }
                                                            m.fail(8185, e.toString());
                                                        }
                                                    }
                                                });
                                            }
                                        });
                                    } else {
                                        Future<Void> future = dup.executeBlocking(new Callable<Void>(){

                                            @Override
                                            public Void call() {
                                                try {
                                                    invoker.invoke(m);
                                                }
                                                catch (Exception e) {
                                                    if (m.replyAddress() == null) {
                                                        throw VertxEventBusConsumerRecorder.wrapIfNecessary(e);
                                                    }
                                                    m.fail(8185, e.toString());
                                                }
                                                return null;
                                            }
                                        }, invoker.isOrdered());
                                        future.onFailure(context::reportException);
                                    }
                                } else {
                                    VertxContextSafetyToggle.setCurrentContextSafe(true);
                                    try {
                                        invoker.invoke(m);
                                    }
                                    catch (Exception e) {
                                        if (m.replyAddress() == null) {
                                            throw VertxEventBusConsumerRecorder.wrapIfNecessary(e);
                                        }
                                        m.fail(8185, e.toString());
                                    }
                                }
                            }
                        });
                        consumer.completionHandler(new Handler<AsyncResult<Void>>(){

                            @Override
                            public void handle(AsyncResult<Void> ar) {
                                latch.countDown();
                                if (ar.failed()) {
                                    registrationFailures.add(ar.cause());
                                }
                            }
                        });
                        messageConsumers.add(consumer);
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Unable to register all message consumer methods", e);
            }
            if (!registrationFailures.isEmpty()) {
                throw new RuntimeException("Registration of one or more message consumers failed", (Throwable)registrationFailures.get(0));
            }
        }
    }

    static RuntimeException wrapIfNecessary(Throwable e) {
        if (e instanceof Error) {
            throw (Error)e;
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    void unregisterMessageConsumers() {
        CountDownLatch latch = new CountDownLatch(messageConsumers.size());
        for (MessageConsumer<?> messageConsumer : messageConsumers) {
            messageConsumer.unregister(ar -> {
                latch.countDown();
                if (ar.failed()) {
                    LOGGER.warn((Object)"Message consumer unregistration failed", ar.cause());
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Unable to unregister all message consumer methods", e);
        }
        messageConsumers.clear();
    }

    private EventConsumerInvoker createInvoker(String invokerClassName) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = VertxProducer.class.getClassLoader();
            }
            Class<?> invokerClazz = cl.loadClass(invokerClassName);
            return (EventConsumerInvoker)invokerClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to create invoker: " + invokerClassName, e);
        }
    }

    private void registerCodecs(Map<Class<?>, Class<?>> codecByClass, final List<Class<?>> selectorTypes) {
        EventBus eventBus = vertx.eventBus();
        boolean isDevMode = ProfileManager.getLaunchMode() == LaunchMode.DEVELOPMENT;
        for (Map.Entry<Class<?>, Class<?>> codecEntry : codecByClass.entrySet()) {
            Class<?> target = codecEntry.getKey();
            Class<?> codec = codecEntry.getValue();
            try {
                if (MessageCodec.class.isAssignableFrom(codec)) {
                    MessageCodec messageCodec = (MessageCodec)codec.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (isDevMode) {
                        eventBus.unregisterDefaultCodec(target);
                    }
                    eventBus.registerDefaultCodec(target, messageCodec);
                    continue;
                }
                LOGGER.error(String.format("The codec %s does not inherit from MessageCodec ", target.toString()));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.error((Object)("Cannot instantiate the MessageCodec " + target.toString()), e);
            }
        }
        final String localCodecName = "quarkus_default_local_codec";
        if (isDevMode) {
            eventBus.unregisterCodec(localCodecName);
        }
        eventBus.registerCodec(new LocalEventBusCodec(localCodecName));
        eventBus.codecSelector(new Function<Object, String>(){

            @Override
            public String apply(Object messageBody) {
                for (Class selectorType : selectorTypes) {
                    if (!selectorType.isAssignableFrom(messageBody.getClass())) continue;
                    return localCodecName;
                }
                return null;
            }
        });
    }

    public RuntimeValue<Vertx> forceStart(Supplier<Vertx> vertx) {
        return new RuntimeValue<Vertx>(vertx.get());
    }

    private static String lookUpPropertyValue(String propertyValue) {
        String value = propertyValue.stripLeading();
        if (!value.isEmpty() && VertxEventBusConsumerRecorder.isConfigExpression(value)) {
            value = VertxEventBusConsumerRecorder.resolvePropertyExpression(value);
        }
        return value;
    }

    private static String resolvePropertyExpression(final String expr) {
        ClassLoader cl = VertxEventBusConsumerRecorder.class.getClassLoader();
        final Config config = ConfigProviderResolver.instance().getConfig(cl);
        Expression expression = Expression.compile(expr, Expression.Flag.LENIENT_SYNTAX, Expression.Flag.NO_TRIM);
        String expanded = expression.evaluate(new BiConsumer<ResolveContext<RuntimeException>, StringBuilder>(){

            @Override
            public void accept(ResolveContext<RuntimeException> resolveContext, StringBuilder stringBuilder) {
                Optional<String> resolve = config.getOptionalValue(resolveContext.getKey(), String.class);
                if (resolve.isPresent()) {
                    stringBuilder.append(resolve.get());
                } else if (resolveContext.hasDefault()) {
                    resolveContext.expandDefault();
                } else {
                    throw new NoSuchElementException(String.format("Could not expand value %s in property %s", resolveContext.getKey(), expr));
                }
            }
        });
        return expanded;
    }

    private static boolean isConfigExpression(String val) {
        if (val == null) {
            return false;
        }
        int exprStart = val.indexOf("${");
        int exprEnd = -1;
        if (exprStart >= 0) {
            exprEnd = val.indexOf(125, exprStart + 2);
        }
        return exprEnd > 0;
    }
}

