/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.Converters;
import io.smallrye.config.common.AbstractConfigSource;
import io.smallrye.config.common.utils.StringUtil;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EnvConfigSource
extends AbstractConfigSource {
    private static final long serialVersionUID = -4525015934376795496L;
    public static final String NAME = "EnvConfigSource";
    public static final int ORDINAL = 300;
    private final EnvVars envVars;

    protected EnvConfigSource() {
        this(300);
    }

    protected EnvConfigSource(int ordinal) {
        this(EnvConfigSource.getEnvProperties(), ordinal);
    }

    public EnvConfigSource(Map<String, String> properties, int ordinal) {
        super(NAME, EnvConfigSource.getEnvOrdinal(properties, ordinal));
        this.envVars = new EnvVars(properties);
    }

    @Override
    public Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry<EnvName, EnvEntry> entry : this.envVars.getEnv().entrySet()) {
            EnvEntry entryValue = entry.getValue();
            if (entryValue.getEntries() != null) {
                properties.putAll(entryValue.getEntries());
                continue;
            }
            properties.put(entryValue.getName(), entryValue.getValue());
        }
        return properties;
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.envVars.getNames();
    }

    @Override
    public String getValue(String propertyName) {
        return this.envVars.get(propertyName);
    }

    boolean hasPropertyName(String propertyName) {
        return this.envVars.getEnv().containsKey(new EnvName(propertyName));
    }

    private static Map<String, String> getEnvProperties() {
        return AccessController.doPrivileged(new PrivilegedAction<Map<String, String>>(){

            @Override
            public Map<String, String> run() {
                return new HashMap<String, String>(System.getenv());
            }
        });
    }

    private static int getEnvOrdinal(Map<String, String> properties, int ordinal) {
        String value = properties.get("config_ordinal");
        if (value == null) {
            value = properties.get("config_ordinal".toUpperCase());
        }
        if (value != null) {
            return Converters.INTEGER_CONVERTER.convert(value);
        }
        return ordinal;
    }

    Object writeReplace() {
        return new Ser();
    }

    static final class EnvEntry
    implements Serializable {
        private static final long serialVersionUID = -8786927401082731020L;
        private final String name;
        private final String value;
        private Map<String, String> envEntries;

        EnvEntry(String name, String value) {
            this.name = name;
            this.value = value;
        }

        String getName() {
            return this.name;
        }

        String getValue() {
            return this.value;
        }

        String get() {
            return this.envEntries == null ? this.value : null;
        }

        Map<String, String> getEntries() {
            return this.envEntries;
        }

        void add(String name, String value) {
            if (this.envEntries == null) {
                this.envEntries = new HashMap<String, String>();
                this.envEntries.put(this.name, this.value);
            }
            this.envEntries.put(name, value);
        }
    }

    static final class EnvName
    implements Serializable {
        private static final long serialVersionUID = -2679716955093904512L;
        private final String name;

        public EnvName(String name) {
            assert (name != null);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EnvName that = (EnvName)o;
            return EnvName.equals(this.name, that.name);
        }

        public int hashCode() {
            int h = 0;
            int length = this.name.length();
            if (length >= 2 && this.name.charAt(length - 1) == '_' && this.name.charAt(length - 2) == '_') {
                --length;
            }
            for (int i = 0; i < length; ++i) {
                char c = this.name.charAt(i);
                if (i == 0 && length > 1 && (c == '%' || c == '_') && StringUtil.isAsciiLetterOrDigit(this.name.charAt(i + 1))) {
                    h = 31 * h + 31;
                    continue;
                }
                if (!StringUtil.isAsciiLetterOrDigit(c)) continue;
                h = 31 * h + Character.toLowerCase(c);
            }
            return h;
        }

        static boolean equals(String name, String other) {
            if (name == other) {
                return true;
            }
            if (name.isEmpty() && other.isEmpty()) {
                return true;
            }
            if (name.isEmpty() || other.isEmpty()) {
                return false;
            }
            int matchPosition = name.length() - 1;
            for (int i = other.length() - 1; i >= 0; --i) {
                if (matchPosition == -1) {
                    return false;
                }
                char o = other.charAt(i);
                char n = name.charAt(matchPosition);
                if (!(i != 0 || o != '%' && o != '_' || n != '%' && n != '_')) {
                    return true;
                }
                if (o == '.') {
                    if (n != '.' && n != '-' && n != '_' && n != '/') {
                        return false;
                    }
                } else if (o == '-') {
                    if (n != '.' && n != '-' && n != '_' && n != '/') {
                        return false;
                    }
                } else if (o == '\"') {
                    if (n != '\"' && n != '_') {
                        return false;
                    }
                    if (n == '_' && name.length() - 1 == matchPosition && (matchPosition = name.lastIndexOf("_", matchPosition - 1)) == -1) {
                        return false;
                    }
                } else {
                    if (o == ']') {
                        if (n != ']' && n != '_') {
                            return false;
                        }
                        int beginIndexed = other.lastIndexOf(91, i);
                        if (beginIndexed != -1) {
                            int range = i - beginIndexed - 1;
                            if ((name.lastIndexOf(95, matchPosition - 1) == matchPosition - range - 1 || name.lastIndexOf(91, matchPosition - 1) == matchPosition - range - 1) && StringUtil.isNumeric(other, beginIndexed + range, i) && StringUtil.isNumeric(name, matchPosition - range, matchPosition)) {
                                matchPosition = matchPosition - range - 2;
                                i = i - range - 1;
                                continue;
                            }
                        }
                        return false;
                    }
                    if (o == '_') {
                        if (StringUtil.isAsciiLetterOrDigit(n)) {
                            return false;
                        }
                        if (n == '\"' && other.length() - 1 == i && (i = other.lastIndexOf("_", i - 1)) == -1) {
                            return false;
                        }
                    } else if (!StringUtil.isAsciiLetterOrDigit(o) ? o != n && n != '_' : Character.toLowerCase(o) != Character.toLowerCase(n)) {
                        return false;
                    }
                }
                --matchPosition;
            }
            return matchPosition <= 0;
        }
    }

    static final class EnvVars
    implements Serializable {
        private static final long serialVersionUID = -56318356411229247L;
        private final Map<EnvName, EnvEntry> env;
        private final Set<String> names;

        public EnvVars(Map<String, String> properties) {
            this.env = new HashMap<EnvName, EnvEntry>(properties.size());
            this.names = new HashSet<String>(properties.size() * 2);
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                EnvName envName = new EnvName(entry.getKey());
                EnvEntry envEntry = this.env.get(envName);
                if (envEntry == null) {
                    this.env.put(envName, new EnvEntry(entry.getKey(), entry.getValue()));
                } else {
                    envEntry.add(entry.getKey(), entry.getValue());
                }
                this.names.add(entry.getKey());
                this.names.add(StringUtil.toLowerCaseAndDotted(entry.getKey()));
            }
        }

        public String get(String propertyName) {
            EnvEntry envEntry = this.env.get(new EnvName(propertyName));
            if (envEntry != null) {
                String value = envEntry.get();
                if (value != null) {
                    return value;
                }
                value = envEntry.getEntries().get(propertyName);
                if (value != null) {
                    return value;
                }
                String envName = StringUtil.replaceNonAlphanumericByUnderscores(propertyName);
                value = envEntry.getEntries().get(envName);
                if (value != null) {
                    return value;
                }
                return envEntry.envEntries.get(envName.toUpperCase());
            }
            return null;
        }

        public Map<EnvName, EnvEntry> getEnv() {
            return this.env;
        }

        public Set<String> getNames() {
            return this.names;
        }
    }

    static final class Ser
    implements Serializable {
        private static final long serialVersionUID = 6812312718645271331L;

        Ser() {
        }

        Object readResolve() {
            return new EnvConfigSource();
        }
    }
}

