/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.matchers.psystem.rewriters;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.PBodyCopier;

public class FlattenerCopier
extends PBodyCopier {
    private List<PositivePatternCall> callsToFlatten;
    private List<PBody> calledBodies;
    private ListMultimap<PVariable, PVariable> variableMultimap = ArrayListMultimap.create();
    private Map<PQuery, Integer> patternCallCounter = Maps.newHashMap();

    @Override
    protected void copyVariable(PVariable variable, String newName) {
        PVariable newPVariable = this.body.getOrCreateVariableByName(newName);
        this.variableMapping.put(variable, newPVariable);
        this.variableMultimap.put((Object)variable, (Object)newPVariable);
    }

    public FlattenerCopier(PQuery query, List<PositivePatternCall> callsToFlatten, List<PBody> calledBodies) {
        super(query);
        this.callsToFlatten = callsToFlatten;
        this.calledBodies = Lists.newArrayList(calledBodies);
    }

    @Override
    protected void copyPositivePatternCallConstraint(PositivePatternCall positivePatternCall) {
        if (!this.callsToFlatten.contains(positivePatternCall)) {
            super.copyPositivePatternCallConstraint(positivePatternCall);
        } else {
            PBody bodyToRemoveFromList = null;
            for (PBody calledBody : this.calledBodies) {
                if (!positivePatternCall.getReferredQuery().equals(calledBody.getPattern())) continue;
                PQuery pattern = calledBody.getPattern();
                int callIndex = 0;
                if (this.patternCallCounter.containsKey(pattern)) {
                    callIndex = this.patternCallCounter.get(pattern);
                    this.patternCallCounter.put(pattern, ++callIndex);
                } else {
                    this.patternCallCounter.put(pattern, 0);
                }
                List<PVariable> symbolicParameters = calledBody.getSymbolicParameterVariables();
                Object[] elements = positivePatternCall.getVariablesTuple().getElements();
                int i = 0;
                while (i < elements.length) {
                    this.createEqualityConstraint((PVariable)elements[i], symbolicParameters.get(i), callIndex);
                    ++i;
                }
                bodyToRemoveFromList = calledBody;
                break;
            }
            this.calledBodies.remove(bodyToRemoveFromList);
        }
    }

    private void createEqualityConstraint(PVariable pVariable1, PVariable pVariable2, int index) {
        new Equality(this.body, (PVariable)this.variableMultimap.get((Object)pVariable1).get(0), (PVariable)this.variableMultimap.get((Object)pVariable2).get(index));
    }
}

