/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.sources;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.incquery.viewers.runtime.ViewersRuntimePlugin;
import org.eclipse.incquery.viewers.runtime.model.Containment;
import org.eclipse.incquery.viewers.runtime.model.Edge;
import org.eclipse.incquery.viewers.runtime.model.Item;
import org.eclipse.incquery.viewers.runtime.model.ViewerState;
import org.eclipse.incquery.viewers.runtime.model.listeners.AbstractViewerLabelListener;
import org.eclipse.incquery.viewers.runtime.model.listeners.IViewerLabelListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;

public class QueryLabelProvider
extends LabelProvider {
    private IViewerLabelListener labelListener = new AbstractViewerLabelListener(){

        @Override
        public void labelUpdated(Item item, String newLabel) {
            QueryLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)QueryLabelProvider.this, (Object)item));
        }

        @Override
        public void labelUpdated(Edge edge, String newLabel) {
            QueryLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)QueryLabelProvider.this, (Object)edge));
        }
    };
    private ViewerState state;
    private Image itemIcon;
    private Image edgeIcon;
    private Image contIcon;

    public QueryLabelProvider(ViewerState state) {
        this.state = state;
        state.addLabelListener(this.labelListener);
        this.itemIcon = ViewersRuntimePlugin.imageDescriptorFromPlugin((String)"org.eclipse.incquery.viewers.runtime", (String)"icons/item.gif").createImage();
        this.edgeIcon = ViewersRuntimePlugin.imageDescriptorFromPlugin((String)"org.eclipse.incquery.viewers.runtime", (String)"icons/edge.gif").createImage();
        this.contIcon = ViewersRuntimePlugin.imageDescriptorFromPlugin((String)"org.eclipse.incquery.viewers.runtime", (String)"icons/containment.gif").createImage();
    }

    public String getText(Object element) {
        if (element instanceof Item) {
            IObservableValue value = ((Item)element).getLabel();
            return value.getValue().toString();
        }
        if (element instanceof Edge) {
            IObservableValue value = ((Edge)element).getLabel();
            return value.getValue().toString();
        }
        return "";
    }

    public Image getImage(Object element) {
        if (element instanceof Item) {
            return this.itemIcon;
        }
        if (element instanceof Containment) {
            return this.contIcon;
        }
        if (element instanceof Edge) {
            return this.edgeIcon;
        }
        return super.getImage(element);
    }

    public void dispose() {
        this.itemIcon.dispose();
        this.edgeIcon.dispose();
        this.contIcon.dispose();
        this.state.removeLabelListener(this.labelListener);
        super.dispose();
    }
}

