/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.emf.ui.builder;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.incquery.patternlanguage.emf.ui.builder.EclipseResourceSupport;
import org.eclipse.incquery.patternlanguage.emf.ui.builder.EnsurePluginSupport;
import org.eclipse.incquery.patternlanguage.emf.ui.builder.OldVersionHelper;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternLanguagePackage;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.tooling.core.generator.GenerateQuerySpecificationExtension;
import org.eclipse.incquery.tooling.core.generator.fragments.IGenerationFragment;
import org.eclipse.incquery.tooling.core.generator.fragments.IGenerationFragmentProvider;
import org.eclipse.incquery.tooling.core.project.ProjectGenerationHelper;
import org.eclipse.xtext.builder.EclipseResourceFileSystemAccess2;
import org.eclipse.xtext.builder.IXtextBuilderParticipant;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.xbase.lib.Pair;

public class CleanSupport {
    @Inject
    private Injector injector;
    @Inject
    private IGenerationFragmentProvider fragmentProvider;
    @Inject
    private EclipseResourceSupport eclipseResourceSupport;
    @Inject
    private EnsurePluginSupport ensureSupport;
    @Inject
    private Logger logger;

    public void fullClean(IXtextBuilderParticipant.IBuildContext context, IProgressMonitor monitor) {
        try {
            try {
                this.internalFullClean(context, monitor);
            }
            catch (Exception e) {
                this.logger.error((Object)"Exception during Full Clean!", (Throwable)e);
                monitor.worked(1);
            }
        }
        finally {
            monitor.worked(1);
        }
    }

    private void internalFullClean(IXtextBuilderParticipant.IBuildContext context, IProgressMonitor monitor) throws CoreException, IncQueryException {
        IProject modelProject = context.getBuiltProject();
        this.cleanAllFragment(modelProject);
        ArrayList removableExtensions = new ArrayList();
        removableExtensions.addAll(GenerateQuerySpecificationExtension.getRemovableExtensionIdentifiers());
        ProjectGenerationHelper.removeAllExtension((IProject)modelProject, removableExtensions);
    }

    private void cleanAllFragment(IProject modelProject) throws CoreException {
        for (IGenerationFragment fragment : this.fragmentProvider.getAllFragments()) {
            try {
                this.cleanFragment(modelProject, fragment);
            }
            catch (Exception e) {
                this.logger.error((Object)("Exception during full Clean on " + fragment.getClass().getCanonicalName()), (Throwable)e);
            }
        }
    }

    private void cleanFragment(IProject modelProject, IGenerationFragment fragment) throws CoreException {
        IProject fragmentProject = this.fragmentProvider.getFragmentProject(modelProject, fragment);
        if (fragmentProject.exists() && !fragmentProject.equals((Object)modelProject)) {
            fragmentProject.refreshLocal(2, null);
            EclipseResourceFileSystemAccess2 fsa = this.eclipseResourceSupport.createProjectFileSystemAccess(fragmentProject);
            for (OutputConfiguration config : fsa.getOutputConfigurations().values()) {
                this.cleanFragmentFolder(fragmentProject, config);
            }
            ProjectGenerationHelper.removeAllExtension((IProject)fragmentProject, (Collection)fragment.getRemovableExtensions());
            fragmentProject.deleteMarkers("org.eclipse.incquery.tooling.core.generator.marker.fragment", true, 2);
        }
    }

    private void cleanFragmentFolder(IProject fragmentProject, OutputConfiguration config) throws CoreException {
        IFolder folder = fragmentProject.getFolder(config.getOutputDirectory());
        if (folder.exists()) {
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                resource.delete(2, (IProgressMonitor)new NullProgressMonitor());
                ++n2;
            }
        }
    }

    public void normalClean(IXtextBuilderParticipant.IBuildContext context, List<IResourceDescription.Delta> relevantDeltas, IProgressMonitor monitor) {
        try {
            try {
                this.internalNormalClean(context, relevantDeltas, monitor);
            }
            catch (Exception e) {
                this.logger.error((Object)"Exception during Normal Clean!", (Throwable)e);
                monitor.worked(1);
            }
        }
        finally {
            monitor.worked(1);
        }
    }

    private void internalNormalClean(IXtextBuilderParticipant.IBuildContext context, List<IResourceDescription.Delta> relevantDeltas, IProgressMonitor monitor) throws CoreException, IncQueryException {
        for (IResourceDescription.Delta delta : relevantDeltas) {
            if (delta.getOld() == null) continue;
            OldVersionHelper oldVersion = (OldVersionHelper)this.injector.getInstance(OldVersionHelper.class);
            for (IEObjectDescription desc : delta.getOld().getExportedObjectsByType(PatternLanguagePackage.Literals.PATTERN)) {
                Pattern pattern = (Pattern)desc.getEObjectOrProxy();
                if (pattern.eIsProxy()) {
                    pattern = oldVersion.findPattern(((InternalEObject)pattern).eProxyURI());
                }
                String fqn = desc.getQualifiedName().toString();
                if (pattern == null || pattern.eIsProxy()) {
                    context.getBuiltProject().build(15, monitor);
                    return;
                }
                String foundFQN = CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern);
                if (!foundFQN.equals(fqn)) {
                    context.getBuiltProject().build(15, monitor);
                    return;
                }
                this.executeCleanUpOnModelProject(context.getBuiltProject(), fqn);
                this.executeCleanUpOnFragments(context.getBuiltProject(), pattern);
            }
        }
    }

    private void executeCleanUpOnModelProject(IProject modelProject, String fqn) throws CoreException {
        String extensionId = fqn;
        this.ensureSupport.removeExtension(modelProject, (Pair<String, String>)Pair.of((Object)extensionId, (Object)"org.eclipse.incquery.runtime.queryspecification"));
    }

    private void executeCleanUpOnFragments(IProject modelProject, Pattern pattern) throws CoreException {
        for (IGenerationFragment fragment : this.fragmentProvider.getAllFragments()) {
            try {
                this.injector.injectMembers((Object)fragment);
                IProject targetProject = this.fragmentProvider.getFragmentProject(modelProject, fragment);
                if (!targetProject.exists()) continue;
                EclipseResourceFileSystemAccess2 fsa = this.eclipseResourceSupport.createProjectFileSystemAccess(targetProject);
                fragment.cleanUp(pattern, (IFileSystemAccess)fsa);
                this.ensureSupport.removeAllExtension(targetProject, fragment.removeExtension(pattern));
                targetProject.deleteMarkers("org.eclipse.incquery.tooling.core.generator.marker.fragment", true, 2);
            }
            catch (Exception e) {
                String msg = String.format("Exception when executing clean for '%s' in fragment '%s'", CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern), fragment.getClass().getCanonicalName());
                this.logger.error((Object)msg, (Throwable)e);
            }
        }
    }
}

