/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.base.comprehension;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;

public class WellbehavingDerivedFeatureRegistry {
    private static Collection<EStructuralFeature> contributedWellbehavingDerivedFeatures = Collections.newSetFromMap(new WeakHashMap());
    private static Collection<EClass> contributedWellbehavingDerivedClasses = Collections.newSetFromMap(new WeakHashMap());
    private static Collection<EPackage> contributedWellbehavingDerivedPackages = Collections.newSetFromMap(new WeakHashMap());
    private static Multimap<String, String> contributingPluginOfFeatureMap = HashMultimap.create();

    private WellbehavingDerivedFeatureRegistry() {
    }

    public static void initRegistry() {
        WellbehavingDerivedFeatureRegistry.getContributedWellbehavingDerivedFeatures().clear();
        WellbehavingDerivedFeatureRegistry.getContributedWellbehavingDerivedClasses().clear();
        WellbehavingDerivedFeatureRegistry.getContributedWellbehavingDerivedPackages().clear();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint poi = reg.getExtensionPoint("org.eclipse.incquery.runtime.base.wellbehaving.derived.features");
        if (poi != null) {
            IExtension[] exts;
            IExtension[] iExtensionArray = exts = poi.getExtensions();
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] els;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = els = ext.getConfigurationElements();
                int n3 = els.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement el = iConfigurationElementArray[n4];
                    if (!el.getName().equals("wellbehaving-derived-feature")) {
                        throw new UnsupportedOperationException("Unknown configuration element " + el.getName() + " in plugin.xml of " + el.getDeclaringExtension().getUniqueIdentifier());
                    }
                    WellbehavingDerivedFeatureRegistry.processWellbehavingExtension(el);
                    ++n4;
                }
                ++n2;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void processWellbehavingExtension(IConfigurationElement el) {
        try {
            String packageUri = el.getAttribute("package-nsUri");
            String featureName = el.getAttribute("feature-name");
            String classifierName = el.getAttribute("classifier-name");
            String contributorName = el.getContributor().getName();
            StringBuilder featureIdBuilder = new StringBuilder();
            if (packageUri == null) return;
            EPackage pckg = EPackage.Registry.INSTANCE.getEPackage(packageUri);
            featureIdBuilder.append(packageUri);
            if (pckg != null) {
                if (classifierName != null) {
                    EClassifier clsr = pckg.getEClassifier(classifierName);
                    featureIdBuilder.append("##").append(classifierName);
                    if (!(clsr instanceof EClass)) throw new IllegalStateException(String.format("EClassifier %s does not exist in package %s! (plug-in %s)", classifierName, packageUri, contributorName));
                    if (featureName != null) {
                        EClass cls = (EClass)clsr;
                        EStructuralFeature feature = cls.getEStructuralFeature(featureName);
                        featureIdBuilder.append("##").append(featureName);
                        if (feature == null) throw new IllegalStateException(String.format("Feature %s of EClass %s in package %s not found! (plug-in %s)", featureName, classifierName, packageUri, contributorName));
                        WellbehavingDerivedFeatureRegistry.registerWellbehavingDerivedFeature(feature);
                    } else {
                        WellbehavingDerivedFeatureRegistry.registerWellbehavingDerivedClass((EClass)clsr);
                    }
                } else {
                    if (featureName != null) {
                        throw new IllegalStateException(String.format("Feature name must be empty if classifier name is not set! (package %s, plug-in %s)", packageUri, contributorName));
                    }
                    WellbehavingDerivedFeatureRegistry.registerWellbehavingDerivedPackage(pckg);
                }
            }
            contributingPluginOfFeatureMap.put((Object)featureIdBuilder.toString(), (Object)contributorName);
            return;
        }
        catch (Exception e) {
            Logger logger = Logger.getLogger(WellbehavingDerivedFeatureRegistry.class);
            logger.error((Object)"Well-behaving feature registration failed", (Throwable)e);
        }
    }

    public static Multimap<String, String> getContributingPluginOfFeatureMap() {
        return contributingPluginOfFeatureMap;
    }

    public static boolean isWellbehavingFeature(EStructuralFeature feature) {
        if (feature == null) {
            return false;
        }
        if (contributedWellbehavingDerivedFeatures.contains(feature)) {
            return true;
        }
        if (contributedWellbehavingDerivedClasses.contains(feature.getEContainingClass())) {
            return true;
        }
        return contributedWellbehavingDerivedPackages.contains(feature.getEContainingClass().getEPackage());
    }

    public static void registerWellbehavingDerivedFeature(EStructuralFeature feature) {
        contributedWellbehavingDerivedFeatures.add(feature);
    }

    public static void registerWellbehavingDerivedClass(EClass cls) {
        contributedWellbehavingDerivedClasses.add(cls);
    }

    public static void registerWellbehavingDerivedPackage(EPackage pkg) {
        contributedWellbehavingDerivedPackages.add(pkg);
    }

    public static Collection<EStructuralFeature> getContributedWellbehavingDerivedFeatures() {
        return contributedWellbehavingDerivedFeatures;
    }

    public static Collection<EClass> getContributedWellbehavingDerivedClasses() {
        return contributedWellbehavingDerivedClasses;
    }

    public static Collection<EPackage> getContributedWellbehavingDerivedPackages() {
        return contributedWellbehavingDerivedPackages;
    }
}

