/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.update;

import com.google.common.base.Preconditions;
import org.eclipse.incquery.runtime.api.AdvancedIncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryModelUpdateListener;
import org.eclipse.incquery.runtime.evm.update.UpdateCompleteProvider;

public class IQEngineUpdateCompleteProvider
extends UpdateCompleteProvider {
    private final IncQueryModelUpdateListener modelUpdateListener;
    private final AdvancedIncQueryEngine engine;

    public IQEngineUpdateCompleteProvider(IncQueryEngine engine) {
        Preconditions.checkArgument((engine != null ? 1 : 0) != 0, (Object)"Cannot create provider with null engine!");
        this.engine = AdvancedIncQueryEngine.from((IncQueryEngine)engine);
        this.modelUpdateListener = new ModelUpdateListener();
    }

    @Override
    protected void firstListenerAdded() {
        super.firstListenerAdded();
        this.engine.addModelUpdateListener(this.modelUpdateListener);
    }

    @Override
    protected void lastListenerRemoved() {
        super.lastListenerRemoved();
        this.engine.removeModelUpdateListener(this.modelUpdateListener);
    }

    private final class ModelUpdateListener
    implements IncQueryModelUpdateListener {
        private ModelUpdateListener() {
        }

        public void notifyChanged(IncQueryModelUpdateListener.ChangeLevel changeLevel) {
            IQEngineUpdateCompleteProvider.this.updateCompleted();
        }

        public IncQueryModelUpdateListener.ChangeLevel getLevel() {
            return IncQueryModelUpdateListener.ChangeLevel.MODEL;
        }
    }
}

