/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.localsearch.plan;

import com.google.common.base.Preconditions;
import java.util.List;
import org.eclipse.incquery.runtime.localsearch.MatchingFrame;
import org.eclipse.incquery.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.incquery.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.incquery.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.incquery.runtime.localsearch.plan.SearchPlan;

public class SearchPlanExecutor {
    private int currentOperation;
    SearchPlan plan;
    private List<ISearchOperation> operations;
    private ISearchContext context;

    public SearchPlanExecutor(SearchPlan plan, ISearchContext context) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"Context cannot be null");
        this.plan = plan;
        this.context = context;
        this.operations = plan.getOperations();
        this.currentOperation = -1;
    }

    private void init(MatchingFrame frame) throws LocalSearchException {
        if (this.currentOperation == -1) {
            ++this.currentOperation;
            this.operations.get(this.currentOperation).onInitialize(frame, this.context);
        } else if (this.currentOperation == this.operations.size()) {
            --this.currentOperation;
        } else {
            throw new LocalSearchException("Error while executing search plan");
        }
    }

    public double cost() {
        return 0.0;
    }

    public boolean execute(MatchingFrame frame) throws LocalSearchException {
        int upperBound = this.operations.size() - 1;
        this.init(frame);
        while (this.currentOperation >= 0 && this.currentOperation <= upperBound) {
            if (this.operations.get(this.currentOperation).execute(frame, this.context)) {
                ++this.currentOperation;
                if (this.currentOperation > upperBound) continue;
                this.operations.get(this.currentOperation).onInitialize(frame, this.context);
                continue;
            }
            this.operations.get(this.currentOperation).onBacktrack(frame, this.context);
            --this.currentOperation;
        }
        return this.currentOperation > upperBound;
    }

    public void resetPlan() {
        this.currentOperation = -1;
    }

    public void printDebugInformation() {
        int i = 0;
        while (i < this.operations.size()) {
            System.out.println("[" + i + "]\t" + this.operations.get(i).toString());
            ++i;
        }
    }
}

