/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.construction.psystem.basicdeferred;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.incquery.runtime.rete.collections.CollectionsFactory;
import org.eclipse.incquery.runtime.rete.construction.RetePatternBuildException;
import org.eclipse.incquery.runtime.rete.construction.Stub;
import org.eclipse.incquery.runtime.rete.construction.psystem.DeferredPConstraint;
import org.eclipse.incquery.runtime.rete.construction.psystem.PSystem;
import org.eclipse.incquery.runtime.rete.construction.psystem.PVariable;

public class Equality<PatternDescription, StubHandle>
extends DeferredPConstraint<PatternDescription, StubHandle> {
    private PVariable who;
    private PVariable withWhom;

    public Equality(PSystem<PatternDescription, StubHandle, ?> pSystem, PVariable who, PVariable withWhom) {
        super(pSystem, Equality.buildSet(who, withWhom));
        this.who = who;
        this.withWhom = withWhom;
    }

    private static Set<PVariable> buildSet(PVariable who, PVariable withWhom) {
        Set<PVariable> set = CollectionsFactory.getSet();
        set.add(who);
        set.add(withWhom);
        return set;
    }

    public boolean isMoot() {
        return this.who.equals(this.withWhom);
    }

    @Override
    public void doReplaceVariable(PVariable obsolete, PVariable replacement) {
        if (obsolete.equals(this.who)) {
            this.who = replacement;
        }
        if (obsolete.equals(this.withWhom)) {
            this.withWhom = replacement;
        }
    }

    @Override
    protected String toStringRest() {
        return this.who.getName() + "=" + this.withWhom.getName();
    }

    public PVariable getWho() {
        return this.who;
    }

    public PVariable getWithWhom() {
        return this.withWhom;
    }

    @Override
    public Set<PVariable> getDeducedVariables() {
        return Collections.emptySet();
    }

    @Override
    public Map<Set<PVariable>, Set<PVariable>> getFunctionalDependencies() {
        HashMap<Set<PVariable>, Set<PVariable>> result = new HashMap<Set<PVariable>, Set<PVariable>>();
        result.put(Collections.singleton(this.who), Collections.singleton(this.withWhom));
        result.put(Collections.singleton(this.withWhom), Collections.singleton(this.who));
        return result;
    }

    @Override
    public boolean isReadyAt(Stub<StubHandle> stub) {
        return stub.getVariablesIndex().containsKey(this.who) && stub.getVariablesIndex().containsKey(this.withWhom);
    }

    @Override
    protected Stub<StubHandle> doCheckOn(Stub<StubHandle> stub) throws RetePatternBuildException {
        if (this.isMoot()) {
            return stub;
        }
        Integer index1 = stub.getVariablesIndex().get(this.who);
        Integer index2 = stub.getVariablesIndex().get(this.withWhom);
        if (index1 != null && index2 != null) {
            if (index1.equals(index2)) {
                return stub;
            }
            return this.buildable.buildEqualityChecker(stub, new int[]{index1, index2});
        }
        return null;
    }

    @Override
    public void raiseForeverDeferredError(Stub<StubHandle> stub) throws RetePatternBuildException {
        String[] args = new String[]{this.who.toString(), this.withWhom.toString()};
        String msg = "Cannot express equality of variables {1} and {2} if neither of them is deducable.";
        String shortMsg = "Equality between undeducible variables.";
        throw new RetePatternBuildException(msg, args, shortMsg, null);
    }
}

