/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.api.impl;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.api.IQueryGroup;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.internal.apiimpl.IncQueryEngineImpl;
import org.eclipse.incquery.runtime.matchers.planning.QueryPlannerException;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQueries;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;

public abstract class BasePatternGroup
implements IQueryGroup {
    @Override
    public void prepare(Notifier emfRoot) throws IncQueryException {
        this.prepare(IncQueryEngine.on(emfRoot));
    }

    @Override
    public void prepare(IncQueryEngine engine) throws IncQueryException {
        try {
            HashSet patterns = new HashSet(this.getSpecifications());
            Collection uninitializedPatterns = Collections2.transform((Collection)Collections2.filter(patterns, (Predicate)PQueries.queryStatusPredicate((PQuery.PQueryStatus)PQuery.PQueryStatus.UNINITIALIZED)), (Function)PQueries.queryNameFunction());
            Preconditions.checkState((boolean)uninitializedPatterns.isEmpty(), (String)"Uninitialized query(s) found: %s", (Object[])new Object[]{Joiner.on((String)", ").join((Iterable)uninitializedPatterns)});
            Collection erroneousPatterns = Collections2.transform((Collection)Collections2.filter(patterns, (Predicate)PQueries.queryStatusPredicate((PQuery.PQueryStatus)PQuery.PQueryStatus.ERROR)), (Function)PQueries.queryNameFunction());
            Preconditions.checkState((boolean)erroneousPatterns.isEmpty(), (String)"Erroneous query(s) found: %s", (Object[])new Object[]{Joiner.on((String)", ").join((Iterable)erroneousPatterns)});
            IncQueryEngineImpl engineImpl = (IncQueryEngineImpl)engine;
            engineImpl.getReteEngine().buildMatchersCoalesced(patterns);
        }
        catch (QueryPlannerException e) {
            throw new IncQueryException(e);
        }
    }
}

