/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.eclipse.incquery.databinding.runtime.collection.ObservablePatternMatchCollectionBuilder;
import org.eclipse.incquery.databinding.runtime.collection.ObservablePatternMatchList;
import org.eclipse.incquery.databinding.runtime.collection.ObservablePatternMatchSet;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.evm.api.RuleEngine;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryFilterSemantics;
import org.eclipse.incquery.viewers.runtime.model.ViewerFilterDefinition;

public class ViewerDataFilter {
    public static ViewerDataFilter UNFILTERED = new ViewerDataFilter();
    private Map<IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>, ViewerFilterDefinition> filterDefinitions;

    public ViewerDataFilter() {
        this.filterDefinitions = Maps.newHashMap();
    }

    private ViewerDataFilter(Map<IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>, ViewerFilterDefinition> filters) {
        this.filterDefinitions = Maps.newHashMap(filters);
    }

    public static ViewerDataFilter cloneFilter(ViewerDataFilter other) {
        return new ViewerDataFilter(other.filterDefinitions);
    }

    public void addSingleFilter(IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>> pattern, IPatternMatch match) {
        Preconditions.checkArgument((!this.filterDefinitions.containsKey(pattern) ? 1 : 0) != 0, (Object)("Filter already defined for pattern " + pattern.getFullyQualifiedName()));
        this.filterDefinitions.put(pattern, new ViewerFilterDefinition(pattern, IncQueryFilterSemantics.SINGLE, match, null));
    }

    public void addMultiFilter(IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>> pattern, Collection<IPatternMatch> matches, IncQueryFilterSemantics semantics) {
        Preconditions.checkArgument((!this.filterDefinitions.containsKey(pattern) ? 1 : 0) != 0, (Object)("Filter already defined for pattern " + pattern.getFullyQualifiedName()));
        this.filterDefinitions.put(pattern, new ViewerFilterDefinition(pattern, semantics, null, matches));
    }

    public void removeFilter(IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>> pattern) {
        Preconditions.checkArgument((boolean)this.filterDefinitions.containsKey(pattern), (Object)("Filter undefined for pattern " + pattern.getFullyQualifiedName()));
        this.filterDefinitions.remove(pattern);
    }

    public boolean isFiltered(IQuerySpecification<?> pattern) {
        return this.filterDefinitions.containsKey(pattern);
    }

    public ViewerFilterDefinition getFilter(IQuerySpecification<?> pattern) {
        return this.filterDefinitions.get(pattern);
    }

    public <Match extends IPatternMatch> ObservablePatternMatchSet<Match> getObservableSet(IQuerySpecification<? extends IncQueryMatcher<Match>> querySpecification, RuleEngine engine) {
        ObservablePatternMatchCollectionBuilder builder = ObservablePatternMatchCollectionBuilder.create(querySpecification).setEngine(engine);
        this.prepareFilter(querySpecification, builder);
        return builder.buildSet();
    }

    public <Match extends IPatternMatch> ObservablePatternMatchList<Match> getObservableList(IQuerySpecification<? extends IncQueryMatcher<Match>> querySpecification, RuleEngine engine) {
        ObservablePatternMatchCollectionBuilder builder = ObservablePatternMatchCollectionBuilder.create(querySpecification).setEngine(engine);
        this.prepareFilter(querySpecification, builder);
        return builder.buildList();
    }

    private <Match extends IPatternMatch> void prepareFilter(IQuerySpecification<? extends IncQueryMatcher<Match>> querySpecification, ObservablePatternMatchCollectionBuilder<Match> builder) {
        if (this.isFiltered(querySpecification)) {
            ViewerFilterDefinition def = this.getFilter(querySpecification);
            switch (def.semantics) {
                case SINGLE: {
                    IPatternMatch singleFilterMatch = def.singleFilterMatch;
                    builder.setFilter(singleFilterMatch);
                    break;
                }
                default: {
                    Collection<IPatternMatch> filterMatches = def.filterMatches;
                    builder.setFilter(filterMatches, def.semantics);
                }
            }
        }
    }
}

