/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;
import org.eclipse.incquery.viewers.runtime.model.Containment;
import org.eclipse.incquery.viewers.runtime.model.Edge;
import org.eclipse.incquery.viewers.runtime.model.Item;
import org.eclipse.incquery.viewers.runtime.model.patterns.Param2containmentMatch;
import org.eclipse.incquery.viewers.runtime.model.patterns.Param2containmentMatcher;
import org.eclipse.incquery.viewers.runtime.model.patterns.Param2edgeMatch;
import org.eclipse.incquery.viewers.runtime.model.patterns.Param2edgeMatcher;
import org.eclipse.incquery.viewers.runtime.model.patterns.Param2itemMatch;
import org.eclipse.incquery.viewers.runtime.model.patterns.Param2itemMatcher;

public final class ViewerTraceabilityUtil {
    private ViewerTraceabilityUtil() {
    }

    public static Collection<Item> traceToItem(IncQueryEngine engine, Object source) {
        ArrayList list = Lists.newArrayList();
        Collection<Param2itemMatch> allMatches = ViewerTraceabilityUtil.executeParam2itemMatcher(engine, source);
        for (Param2itemMatch match : allMatches) {
            list.add(match.getItem());
        }
        return list;
    }

    private static Collection<Param2itemMatch> executeParam2itemMatcher(IncQueryEngine engine, Object source) {
        try {
            Param2itemMatcher matcher = Param2itemMatcher.on(engine);
            return matcher.getAllMatches(source, null, null);
        }
        catch (IncQueryException e) {
            Logger logger = IncQueryLoggingUtil.getLogger(ViewerTraceabilityUtil.class);
            logger.error((Object)e.getMessage());
            return Collections.emptySet();
        }
    }

    public static Collection<Edge> traceToEdge(IncQueryEngine engine, Object source, Object target) {
        ArrayList list = Lists.newArrayList();
        Collection<Param2edgeMatch> allMatches = ViewerTraceabilityUtil.executeParam2edgeMatcher(engine, source, target);
        for (Param2edgeMatch match : allMatches) {
            list.add(match.getEdge());
        }
        return list;
    }

    private static Collection<Param2edgeMatch> executeParam2edgeMatcher(IncQueryEngine engine, Object source, Object target) {
        try {
            Param2edgeMatcher matcher = Param2edgeMatcher.on(engine);
            return matcher.getAllMatches(source, target, null, null);
        }
        catch (IncQueryException e) {
            Logger logger = IncQueryLoggingUtil.getLogger(ViewerTraceabilityUtil.class);
            logger.error((Object)e.getMessage());
            return Collections.emptySet();
        }
    }

    public static Collection<Containment> traceTocontainment(IncQueryEngine engine, Object source, Object target) {
        ArrayList list = Lists.newArrayList();
        Collection<Param2containmentMatch> allMatches = ViewerTraceabilityUtil.executeParam2containmentMatcher(engine, source, target);
        for (Param2containmentMatch match : allMatches) {
            list.add(match.getContainment());
        }
        return list;
    }

    private static Collection<Param2containmentMatch> executeParam2containmentMatcher(IncQueryEngine engine, Object source, Object target) {
        try {
            Param2containmentMatcher matcher = Param2containmentMatcher.on(engine);
            return matcher.getAllMatches(source, target, null, null);
        }
        catch (IncQueryException e) {
            Logger logger = IncQueryLoggingUtil.getLogger(ViewerTraceabilityUtil.class);
            logger.error((Object)e.getMessage());
            return Collections.emptySet();
        }
    }

    public static Collection<Item> deleteTracesAndItems(IncQueryEngine engine, Object source) {
        ArrayList list = Lists.newArrayList();
        Collection<Param2itemMatch> allMatches = ViewerTraceabilityUtil.executeParam2itemMatcher(engine, source);
        for (Param2itemMatch match : allMatches) {
            EcoreUtil.delete((EObject)match.getTrace());
            EcoreUtil.delete((EObject)match.getItem());
            list.add(match.getItem());
        }
        return list;
    }

    public static Collection<Edge> deleteTracesAndEdges(IncQueryEngine engine, Object source, Object target) {
        ArrayList list = Lists.newArrayList();
        Collection<Param2edgeMatch> allMatches = ViewerTraceabilityUtil.executeParam2edgeMatcher(engine, source, target);
        for (Param2edgeMatch match : allMatches) {
            EcoreUtil.delete((EObject)match.getTrace());
            EcoreUtil.delete((EObject)match.getEdge());
            list.add(match.getEdge());
        }
        return list;
    }

    public static Collection<Containment> deleteTracesAndContainments(IncQueryEngine engine, Object source, Object target) {
        ArrayList list = Lists.newArrayList();
        Collection<Param2containmentMatch> allMatches = ViewerTraceabilityUtil.executeParam2containmentMatcher(engine, source, target);
        for (Param2containmentMatch match : allMatches) {
            match.getContainment().getTarget().setParent(null);
            EcoreUtil.delete((EObject)match.getTrace());
            EcoreUtil.delete((EObject)match.getContainment());
            list.add(match.getContainment());
        }
        return list;
    }
}

