/*******************************************************************************
 * Copyright (c) 2011 itemis AG (http://www.itemis.eu) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package org.eclipse.xtext.ui.compare;

import java.io.InputStream;

import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;

/**
 * @author Michael Clay - Initial contribution and API
 */
public class StreamContentAccessorDelegate implements IStreamContentAccessor, IResourceProvider {
	private IStreamContentAccessor streamContentAccessor;
	private IResourceProvider resourceProvider;

	public StreamContentAccessorDelegate(IStreamContentAccessor streamContentAccessor,
			IResourceProvider resourceProvider) {
		super();
		Assert.isNotNull(streamContentAccessor, "parameter 'streamContentAccessor' must not be null");
		Assert.isNotNull(resourceProvider, "parameter 'resourceProvider' must not be null");
		this.streamContentAccessor = streamContentAccessor;
		this.resourceProvider = resourceProvider;
	}

	public InputStream getContents() throws CoreException {
		return streamContentAccessor.getContents();
	}

	@Override
	public boolean equals(Object object) {
		return streamContentAccessor.equals(object);
	}

	@Override
	public int hashCode() {
		return streamContentAccessor.hashCode();
	}

	public IResource getResource() {
		return resourceProvider.getResource();
	}

}


