/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.emf.validation;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.incquery.patternlanguage.emf.validation.PatternValidationStatus;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.Issue;

public final class PatternSetValidationDiagnostics
implements IAcceptor<Issue> {
    Set<Issue> foundErrors = Sets.newHashSet();
    Set<Issue> foundWarnings = Sets.newHashSet();

    public void accept(Issue issue) {
        switch (issue.getSeverity()) {
            case ERROR: {
                this.foundErrors.add(issue);
                break;
            }
            case WARNING: {
                this.foundWarnings.add(issue);
                break;
            }
        }
    }

    public PatternValidationStatus getStatus() {
        if (!this.foundErrors.isEmpty()) {
            return PatternValidationStatus.ERROR;
        }
        if (!this.foundWarnings.isEmpty()) {
            return PatternValidationStatus.WARNING;
        }
        return PatternValidationStatus.OK;
    }

    public Set<Issue> getAllErrors() {
        return Sets.newHashSet(this.foundErrors);
    }

    public Set<Issue> getAllWarnings() {
        return Sets.newHashSet(this.foundWarnings);
    }

    public void logErrors(Logger logger) {
        for (Issue diag : this.foundErrors) {
            logger.error((Object)this.stringRepresentation(diag));
        }
    }

    public void logAllMessages(Logger logger) {
        this.logErrors(logger);
        for (Issue diag : this.foundWarnings) {
            logger.warn((Object)this.stringRepresentation(diag));
        }
    }

    private String stringRepresentation(Issue issue) {
        return String.format("[%s] %s", issue.getSeverity().toString(), issue.getMessage());
    }
}

