/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.validation;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.incquery.patternlanguage.patternLanguage.ParameterRef;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;

class VariableReferenceCount {
    private Variable variable;
    private Map<ReferenceType, Integer> counters = new Hashtable<ReferenceType, Integer>();
    private int size = 0;
    private boolean parameter;

    public VariableReferenceCount(Variable variable, boolean parameter) {
        this.variable = variable;
        this.parameter = parameter;
        ReferenceType[] referenceTypeArray = ReferenceType.values();
        int n = referenceTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReferenceType type = referenceTypeArray[n2];
            this.counters.put(type, 0);
            ++n2;
        }
        if (variable instanceof ParameterRef && ((ParameterRef)variable).getReferredParam().getType() != null) {
            this.counters.put(ReferenceType.POSITIVE, 1);
        }
    }

    public Variable getVariable() {
        return this.variable;
    }

    public int getReferenceCount() {
        return this.size;
    }

    public boolean isParameter() {
        return this.parameter;
    }

    public int getReferenceCount(ReferenceType type) {
        return this.counters.get((Object)type);
    }

    public void incrementCounter(ReferenceType type) {
        ++this.size;
        this.counters.put(type, this.counters.get((Object)type) + 1);
    }

    public static enum ReferenceType {
        POSITIVE,
        NEGATIVE,
        READ_ONLY;

    }
}

