/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.specific.resolver;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.incquery.runtime.evm.api.Activation;
import org.eclipse.incquery.runtime.evm.api.resolver.ChangeableConflictSet;
import org.eclipse.incquery.runtime.evm.api.resolver.ConflictResolver;

public class LifoConflictResolver
implements ConflictResolver {
    @Override
    public LifoConflictSet createConflictSet() {
        return new LifoConflictSet(this);
    }

    public static final class LifoConflictSet
    implements ChangeableConflictSet {
        private LifoConflictResolver resolver;
        private Deque<Activation<?>> activations = new ArrayDeque();

        public LifoConflictSet(LifoConflictResolver resolver) {
            this.resolver = resolver;
        }

        @Override
        public ConflictResolver getConflictResolver() {
            return this.resolver;
        }

        @Override
        public Activation<?> getNextActivation() {
            return this.activations.peek();
        }

        @Override
        public Set<Activation<?>> getNextActivations() {
            if (this.activations.isEmpty()) {
                return Collections.emptySet();
            }
            HashSet activationSet = new HashSet();
            activationSet.add(this.getNextActivation());
            return activationSet;
        }

        @Override
        public Set<Activation<?>> getConflictingActivations() {
            return Collections.unmodifiableSet(Sets.newLinkedHashSet(this.activations));
        }

        @Override
        public boolean addActivation(Activation<?> activation) {
            Preconditions.checkArgument((activation != null ? 1 : 0) != 0, (Object)"Activation cannot be null!");
            if (activation.equals(this.activations.peek())) {
                return false;
            }
            this.activations.remove(activation);
            this.activations.push(activation);
            return true;
        }

        @Override
        public boolean removeActivation(Activation<?> activation) {
            Preconditions.checkArgument((activation != null ? 1 : 0) != 0, (Object)"Activation cannot be null!");
            return this.activations.remove(activation);
        }
    }
}

