/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.internal.matcherbuilder;

import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;
import org.eclipse.incquery.runtime.internal.XtextInjectorProvider;
import org.eclipse.incquery.runtime.internal.matcherbuilder.EPMBodyToPSystem;
import org.eclipse.incquery.runtime.internal.matcherbuilder.XBaseEvaluator;
import org.eclipse.incquery.runtime.rete.construction.RetePatternBuildException;
import org.eclipse.incquery.runtime.rete.construction.Stub;
import org.eclipse.incquery.runtime.rete.construction.psystem.PVariable;
import org.eclipse.incquery.runtime.rete.construction.psystem.basicdeferred.BaseTypeSafeCheckOrEvalConstraint;
import org.eclipse.incquery.runtime.rete.eval.AbstractEvaluator;
import org.eclipse.incquery.runtime.rete.tuple.FlatTuple;
import org.eclipse.xtext.xbase.XExpression;

public class XBaseCheckOrEval<StubHandle>
extends BaseTypeSafeCheckOrEvalConstraint<Pattern, StubHandle> {
    private final XExpression xExpression;
    private final EPMBodyToPSystem<StubHandle, ?> pGraph;
    private final Pattern pattern;

    public XBaseCheckOrEval(EPMBodyToPSystem<StubHandle, ?> pGraph, XExpression xExpression, Pattern pattern, PVariable outputVariable) {
        super(pGraph.pSystem, XBaseCheckOrEval.getExternalPNodeReferencesOfXExpression(pGraph, xExpression), outputVariable);
        this.pGraph = pGraph;
        this.xExpression = xExpression;
        this.pattern = pattern;
    }

    protected Stub<StubHandle> doCheckOn(Stub<StubHandle> stub) throws RetePatternBuildException {
        HashSet<Integer> affectedIndices = new HashSet<Integer>();
        HashMap<String, Integer> tupleNameMap = new HashMap<String, Integer>();
        Injector injector = XtextInjectorProvider.INSTANCE.getInjector();
        List variables = CorePatternLanguageHelper.getUsedVariables((XExpression)this.xExpression, (Iterable)this.pGraph.body.getVariables());
        for (Variable variable : variables) {
            PVariable pNode = this.pGraph.getPNode(variable);
            Integer position = (Integer)stub.getVariablesIndex().get(pNode);
            tupleNameMap.put(variable.getSimpleName(), position);
            affectedIndices.add(position);
        }
        int[] indices = new int[affectedIndices.size()];
        int k = 0;
        for (Integer index : affectedIndices) {
            indices[k++] = index;
        }
        XBaseEvaluator evaluator = new XBaseEvaluator(this.xExpression, tupleNameMap, this.pattern);
        injector.injectMembers((Object)evaluator);
        evaluator.init();
        if (this.outputVariable == null) {
            return this.buildable.buildPredicateChecker((AbstractEvaluator)evaluator, null, indices, stub);
        }
        return this.buildable.buildFunctionEvaluator((AbstractEvaluator)evaluator, stub, (Object)this.outputVariable);
    }

    private static Set<PVariable> getExternalPNodeReferencesOfXExpression(EPMBodyToPSystem<?, ?> pGraph, XExpression xExpression) {
        HashSet<PVariable> result = new HashSet<PVariable>();
        List variables = CorePatternLanguageHelper.getUsedVariables((XExpression)xExpression, (Iterable)pGraph.body.getVariables());
        for (Variable variable : variables) {
            result.add(pGraph.getPNode(variable));
        }
        return result;
    }

    protected String toStringRest() {
        return String.valueOf(new FlatTuple(new ArrayList(this.inputVariables).toArray()).toString()) + "|=" + this.xExpression.toString();
    }

    public Map<Set<PVariable>, Set<PVariable>> getFunctionalDependencies() {
        if (this.outputVariable == null) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(this.inputVariables, Collections.singleton(this.outputVariable));
    }
}

