/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.matchers.psystem.rewriters;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.incquery.runtime.matchers.context.IPatternMatcherContext;
import org.eclipse.incquery.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.incquery.runtime.matchers.planning.helpers.TypeHelper;
import org.eclipse.incquery.runtime.matchers.psystem.ITypeInfoProviderConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Inequality;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeUnary;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PDisjunction;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.PBodyCopier;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.PDisjunctionRewriter;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.RewriterException;

public class PBodyNormalizer
extends PDisjunctionRewriter {
    public boolean calcImpliedTypes;
    private IPatternMatcherContext context;

    public PBodyNormalizer(IPatternMatcherContext context) {
        this(context, true);
    }

    public PBodyNormalizer(IPatternMatcherContext context, boolean calculateImpliedTypes) {
        this.context = context;
        this.calcImpliedTypes = calculateImpliedTypes;
    }

    @Override
    public PDisjunction rewrite(PDisjunction disjunction) throws RewriterException {
        HashSet normalizedBodies = Sets.newHashSet();
        for (PBody body : disjunction.getBodies()) {
            PBodyCopier copier = new PBodyCopier(body);
            PBody modifiedBody = copier.getCopiedBody();
            this.normalizeBody(modifiedBody);
            normalizedBodies.add(modifiedBody);
            modifiedBody.setStatus(PQuery.PQueryStatus.OK);
        }
        return new PDisjunction(normalizedBodies);
    }

    public void setContext(IPatternMatcherContext context) {
        this.context = context;
    }

    public PBody normalizeBody(PBody body) throws RewriterException {
        try {
            return this.normalizeBodyInternal(body);
        }
        catch (QueryProcessingException e) {
            throw new RewriterException("Error during rewriting: {1}", new String[]{e.getMessage()}, e.getShortMessage(), body.getPattern(), e);
        }
    }

    PBody normalizeBodyInternal(PBody body) throws QueryProcessingException {
        this.unifyVariablesAlongEqualities(body);
        this.eliminateWeakInequalities(body);
        this.removeMootEqualities(body);
        if (this.calcImpliedTypes) {
            this.eliminateInferrableUnaryTypes(body, this.context);
        }
        this.checkSanity(body);
        return body;
    }

    private void removeMootEqualities(PBody body) {
        Set<Equality> equals = body.getConstraintsOfType(Equality.class);
        for (Equality equality : equals) {
            if (!equality.isMoot()) continue;
            equality.delete();
        }
    }

    void unifyVariablesAlongEqualities(PBody body) {
        Set<Equality> equals = body.getConstraintsOfType(Equality.class);
        for (Equality equality : equals) {
            if (equality.isMoot()) continue;
            equality.getWho().unifyInto(equality.getWithWhom());
        }
    }

    void eliminateWeakInequalities(PBody body) {
        for (Inequality inequality : body.getConstraintsOfType(Inequality.class)) {
            inequality.eliminateWeak();
        }
    }

    void eliminateInferrableUnaryTypes(PBody body, IPatternMatcherContext context) {
        Set<TypeUnary> constraintsOfType = body.getConstraintsOfType(TypeUnary.class);
        block0: for (TypeUnary typeUnary : constraintsOfType) {
            PVariable var = (PVariable)typeUnary.getVariablesTuple().get(0);
            Object expressedType = typeUnary.getTypeInfo(var);
            Set<ITypeInfoProviderConstraint> typeRestrictors = var.getReferringConstraintsOfType(ITypeInfoProviderConstraint.class);
            typeRestrictors.remove(typeUnary);
            for (ITypeInfoProviderConstraint iTypeRestriction : typeRestrictors) {
                Set<Object> typeClosure;
                Object typeInfo = iTypeRestriction.getTypeInfo(var);
                if (typeInfo == ITypeInfoProviderConstraint.TypeInfoSpecials.NO_TYPE_INFO_PROVIDED || !(typeClosure = TypeHelper.typeClosure(Collections.singleton(typeInfo), context)).contains(expressedType)) continue;
                typeUnary.delete();
                continue block0;
            }
        }
    }

    void checkSanity(PBody body) throws QueryProcessingException {
        for (PConstraint pConstraint : body.getConstraints()) {
            pConstraint.checkSanity();
        }
    }
}

