package org.eclipse.incquery.uml.derivedfeatures;

import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedPatternGroup;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.uml.derivedfeatures.ClassExtensionMatcher;
import org.eclipse.incquery.uml.derivedfeatures.ClassSuperClassMatcher;
import org.eclipse.incquery.uml.derivedfeatures.ClassifierAllParentsMatcher;
import org.eclipse.incquery.uml.derivedfeatures.ClassifierGeneralMatcher;
import org.eclipse.incquery.uml.derivedfeatures.EncapsulatedClassifierOwnedPortMatcher;
import org.eclipse.incquery.uml.derivedfeatures.ExtensionMetaclassEndMatcher;
import org.eclipse.incquery.uml.derivedfeatures.ExtensionMetaclassMatcher;
import org.eclipse.incquery.uml.derivedfeatures.NamedElementNamespaceMatcher;
import org.eclipse.incquery.uml.derivedfeatures.NamedElementQualifiedNameMatcher;
import org.eclipse.incquery.uml.derivedfeatures.NamespaceImportedMemberMatcher;
import org.eclipse.incquery.uml.derivedfeatures.OpaqueExpressionResultMatcher;
import org.eclipse.incquery.uml.derivedfeatures.PackageVisibleMemberMatcher;
import org.eclipse.incquery.uml.derivedfeatures.RedefinableTemplateSignatureInheritedParameterMatcher;
import org.eclipse.incquery.uml.derivedfeatures.StateIsOrthogonalMatcher;
import org.eclipse.incquery.uml.derivedfeatures.StructuredClassifierPartMatcher;
import org.eclipse.incquery.uml.derivedfeatures.util.ClassExtensionQuerySpecification;
import org.eclipse.incquery.uml.derivedfeatures.util.ClassSuperClassQuerySpecification;
import org.eclipse.incquery.uml.derivedfeatures.util.ClassifierAllParentsQuerySpecification;
import org.eclipse.incquery.uml.derivedfeatures.util.ClassifierGeneralQuerySpecification;
import org.eclipse.incquery.uml.derivedfeatures.util.EncapsulatedClassifierOwnedPortQuerySpecification;
import org.eclipse.incquery.uml.derivedfeatures.util.ExtensionMetaclassEndQuerySpecification;
import org.eclipse.incquery.uml.derivedfeatures.util.ExtensionMetaclassQuerySpecification;
import org.eclipse.incquery.uml.derivedfeatures.util.NamedElementNamespaceQuerySpecification;
import org.eclipse.incquery.uml.derivedfeatures.util.NamedElementQualifiedNameQuerySpecification;
import org.eclipse.incquery.uml.derivedfeatures.util.NamespaceImportedMemberQuerySpecification;
import org.eclipse.incquery.uml.derivedfeatures.util.OpaqueExpressionResultQuerySpecification;
import org.eclipse.incquery.uml.derivedfeatures.util.PackageVisibleMemberQuerySpecification;
import org.eclipse.incquery.uml.derivedfeatures.util.RedefinableTemplateSignatureInheritedParameterQuerySpecification;
import org.eclipse.incquery.uml.derivedfeatures.util.StateIsOrthogonalQuerySpecification;
import org.eclipse.incquery.uml.derivedfeatures.util.StructuredClassifierPartQuerySpecification;

/**
 * A pattern group formed of all patterns defined in Handwritten.eiq.
 * 
 * <p>Use the static instance as any {@link org.eclipse.incquery.runtime.api.IPatternGroup}, to conveniently prepare
 * an EMF-IncQuery engine for matching all patterns originally defined in file Handwritten.eiq,
 * in order to achieve better performance than one-by-one on-demand matcher initialization.
 * 
 * <p> From package org.eclipse.incquery.uml.derivedfeatures, the group contains the definition of the following patterns: <ul>
 * <li>classExtension</li>
 * <li>typeOrAllParents</li>
 * <li>classSuperClass</li>
 * <li>classifierAllParents</li>
 * <li>classifierGeneral</li>
 * <li>encapsulatedClassifierOwnedPort</li>
 * <li>extensionMetaclass</li>
 * <li>extensionMetaclassEnd</li>
 * <li>extensionOwnedEnd</li>
 * <li>namedElementQualifiedName</li>
 * <li>namedElementNamespace</li>
 * <li>namespaceImportedMember</li>
 * <li>opaqueExpressionResult</li>
 * <li>packageVisibleMember</li>
 * <li>packageDirectlyVisibleMember</li>
 * <li>packageAllImportedPackages</li>
 * <li>packageImportedPackage</li>
 * <li>redefinableTemplateSignatureInheritedParameter</li>
 * <li>structuredClassifierPart</li>
 * <li>stateIsOrthogonal</li>
 * </ul>
 * 
 * @see IPatternGroup
 * 
 */
@SuppressWarnings("all")
public final class Handwritten extends BaseGeneratedPatternGroup {
  /**
   * Access the pattern group.
   * 
   * @return the singleton instance of the group
   * @throws IncQueryException if there was an error loading the generated code of pattern specifications
   * 
   */
  public static Handwritten instance() throws IncQueryException {
    if (INSTANCE == null) {
    	INSTANCE = new Handwritten();
    }
    return INSTANCE;
  }
  
  private static Handwritten INSTANCE;
  
  private Handwritten() throws IncQueryException {
    querySpecifications.add(ClassExtensionQuerySpecification.instance());
    querySpecifications.add(ClassSuperClassQuerySpecification.instance());
    querySpecifications.add(ClassifierAllParentsQuerySpecification.instance());
    querySpecifications.add(ClassifierGeneralQuerySpecification.instance());
    querySpecifications.add(EncapsulatedClassifierOwnedPortQuerySpecification.instance());
    querySpecifications.add(ExtensionMetaclassQuerySpecification.instance());
    querySpecifications.add(ExtensionMetaclassEndQuerySpecification.instance());
    querySpecifications.add(NamedElementQualifiedNameQuerySpecification.instance());
    querySpecifications.add(NamedElementNamespaceQuerySpecification.instance());
    querySpecifications.add(NamespaceImportedMemberQuerySpecification.instance());
    querySpecifications.add(OpaqueExpressionResultQuerySpecification.instance());
    querySpecifications.add(PackageVisibleMemberQuerySpecification.instance());
    querySpecifications.add(RedefinableTemplateSignatureInheritedParameterQuerySpecification.instance());
    querySpecifications.add(StructuredClassifierPartQuerySpecification.instance());
    querySpecifications.add(StateIsOrthogonalQuerySpecification.instance());
  }
  
  public ClassExtensionQuerySpecification getClassExtension() throws IncQueryException {
    return ClassExtensionQuerySpecification.instance();
  }
  
  public ClassExtensionMatcher getClassExtension(final IncQueryEngine engine) throws IncQueryException {
    return ClassExtensionMatcher.on(engine);
  }
  
  public ClassSuperClassQuerySpecification getClassSuperClass() throws IncQueryException {
    return ClassSuperClassQuerySpecification.instance();
  }
  
  public ClassSuperClassMatcher getClassSuperClass(final IncQueryEngine engine) throws IncQueryException {
    return ClassSuperClassMatcher.on(engine);
  }
  
  public ClassifierAllParentsQuerySpecification getClassifierAllParents() throws IncQueryException {
    return ClassifierAllParentsQuerySpecification.instance();
  }
  
  public ClassifierAllParentsMatcher getClassifierAllParents(final IncQueryEngine engine) throws IncQueryException {
    return ClassifierAllParentsMatcher.on(engine);
  }
  
  public ClassifierGeneralQuerySpecification getClassifierGeneral() throws IncQueryException {
    return ClassifierGeneralQuerySpecification.instance();
  }
  
  public ClassifierGeneralMatcher getClassifierGeneral(final IncQueryEngine engine) throws IncQueryException {
    return ClassifierGeneralMatcher.on(engine);
  }
  
  public EncapsulatedClassifierOwnedPortQuerySpecification getEncapsulatedClassifierOwnedPort() throws IncQueryException {
    return EncapsulatedClassifierOwnedPortQuerySpecification.instance();
  }
  
  public EncapsulatedClassifierOwnedPortMatcher getEncapsulatedClassifierOwnedPort(final IncQueryEngine engine) throws IncQueryException {
    return EncapsulatedClassifierOwnedPortMatcher.on(engine);
  }
  
  public ExtensionMetaclassQuerySpecification getExtensionMetaclass() throws IncQueryException {
    return ExtensionMetaclassQuerySpecification.instance();
  }
  
  public ExtensionMetaclassMatcher getExtensionMetaclass(final IncQueryEngine engine) throws IncQueryException {
    return ExtensionMetaclassMatcher.on(engine);
  }
  
  public ExtensionMetaclassEndQuerySpecification getExtensionMetaclassEnd() throws IncQueryException {
    return ExtensionMetaclassEndQuerySpecification.instance();
  }
  
  public ExtensionMetaclassEndMatcher getExtensionMetaclassEnd(final IncQueryEngine engine) throws IncQueryException {
    return ExtensionMetaclassEndMatcher.on(engine);
  }
  
  public NamedElementQualifiedNameQuerySpecification getNamedElementQualifiedName() throws IncQueryException {
    return NamedElementQualifiedNameQuerySpecification.instance();
  }
  
  public NamedElementQualifiedNameMatcher getNamedElementQualifiedName(final IncQueryEngine engine) throws IncQueryException {
    return NamedElementQualifiedNameMatcher.on(engine);
  }
  
  public NamedElementNamespaceQuerySpecification getNamedElementNamespace() throws IncQueryException {
    return NamedElementNamespaceQuerySpecification.instance();
  }
  
  public NamedElementNamespaceMatcher getNamedElementNamespace(final IncQueryEngine engine) throws IncQueryException {
    return NamedElementNamespaceMatcher.on(engine);
  }
  
  public NamespaceImportedMemberQuerySpecification getNamespaceImportedMember() throws IncQueryException {
    return NamespaceImportedMemberQuerySpecification.instance();
  }
  
  public NamespaceImportedMemberMatcher getNamespaceImportedMember(final IncQueryEngine engine) throws IncQueryException {
    return NamespaceImportedMemberMatcher.on(engine);
  }
  
  public OpaqueExpressionResultQuerySpecification getOpaqueExpressionResult() throws IncQueryException {
    return OpaqueExpressionResultQuerySpecification.instance();
  }
  
  public OpaqueExpressionResultMatcher getOpaqueExpressionResult(final IncQueryEngine engine) throws IncQueryException {
    return OpaqueExpressionResultMatcher.on(engine);
  }
  
  public PackageVisibleMemberQuerySpecification getPackageVisibleMember() throws IncQueryException {
    return PackageVisibleMemberQuerySpecification.instance();
  }
  
  public PackageVisibleMemberMatcher getPackageVisibleMember(final IncQueryEngine engine) throws IncQueryException {
    return PackageVisibleMemberMatcher.on(engine);
  }
  
  public RedefinableTemplateSignatureInheritedParameterQuerySpecification getRedefinableTemplateSignatureInheritedParameter() throws IncQueryException {
    return RedefinableTemplateSignatureInheritedParameterQuerySpecification.instance();
  }
  
  public RedefinableTemplateSignatureInheritedParameterMatcher getRedefinableTemplateSignatureInheritedParameter(final IncQueryEngine engine) throws IncQueryException {
    return RedefinableTemplateSignatureInheritedParameterMatcher.on(engine);
  }
  
  public StructuredClassifierPartQuerySpecification getStructuredClassifierPart() throws IncQueryException {
    return StructuredClassifierPartQuerySpecification.instance();
  }
  
  public StructuredClassifierPartMatcher getStructuredClassifierPart(final IncQueryEngine engine) throws IncQueryException {
    return StructuredClassifierPartMatcher.on(engine);
  }
  
  public StateIsOrthogonalQuerySpecification getStateIsOrthogonal() throws IncQueryException {
    return StateIsOrthogonalQuerySpecification.instance();
  }
  
  public StateIsOrthogonalMatcher getStateIsOrthogonal(final IncQueryEngine engine) throws IncQueryException {
    return StateIsOrthogonalMatcher.on(engine);
  }
}
