package org.eclipse.incquery.uml.derivedfeatures.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.uml.derivedfeatures.ConnectableElementEndMatch;
import org.eclipse.incquery.uml.derivedfeatures.ConnectableElementEndMatcher;

/**
 * A pattern-specific query specification that can instantiate ConnectableElementEndMatcher in a type-safe way.
 * 
 * @see ConnectableElementEndMatcher
 * @see ConnectableElementEndMatch
 * 
 */
@SuppressWarnings("all")
public final class ConnectableElementEndQuerySpecification extends BaseGeneratedEMFQuerySpecification<ConnectableElementEndMatcher> {
  private ConnectableElementEndQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static ConnectableElementEndQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected ConnectableElementEndMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return ConnectableElementEndMatcher.on(engine);
  }
  
  @Override
  public ConnectableElementEndMatch newEmptyMatch() {
    return ConnectableElementEndMatch.newEmptyMatch();
  }
  
  @Override
  public ConnectableElementEndMatch newMatch(final Object... parameters) {
    return ConnectableElementEndMatch.newMatch((org.eclipse.uml2.uml.ConnectableElement) parameters[0], (org.eclipse.uml2.uml.ConnectorEnd) parameters[1]);
  }
  
  private static class LazyHolder {
    private final static ConnectableElementEndQuerySpecification INSTANCE = make();
    
    public static ConnectableElementEndQuerySpecification make() {
      return new ConnectableElementEndQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static ConnectableElementEndQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.incquery.uml.derivedfeatures.connectableElementEnd";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("self","temp1");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("self", "org.eclipse.uml2.uml.ConnectableElement"),new PParameter("temp1", "org.eclipse.uml2.uml.ConnectorEnd"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      {
      	PBody body = new PBody(this);
      	PVariable var_self = body.getOrCreateVariableByName("self");
      	PVariable var_temp1 = body.getOrCreateVariableByName("temp1");
      	PVariable var_connectableElement = body.getOrCreateVariableByName("connectableElement");
      	PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      	PVariable var_connectorEnd = body.getOrCreateVariableByName("connectorEnd");
      	body.setExportedParameters(Arrays.<ExportedParameter>asList(
      		new ExportedParameter(body, var_self, "self"),
      				
      		new ExportedParameter(body, var_temp1, "temp1")
      	));
      	new TypeConstraint(body, new FlatTuple(var_self), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "ConnectableElement")));
      	new TypeConstraint(body, new FlatTuple(var_temp1), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "ConnectorEnd")));
      	new TypeConstraint(body, new FlatTuple(var_temp1), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "ConnectorEnd")));
      	new TypeConstraint(body, new FlatTuple(var_temp1, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "ConnectorEnd", "role")));
      	new Equality(body, var__virtual_0_, var_connectableElement);
      	new Equality(body, var_connectableElement, var_self);
      	new TypeConstraint(body, new FlatTuple(var_connectorEnd), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "ConnectorEnd")));
      	new Equality(body, var_temp1, var_connectorEnd);
      	bodies.add(body);
      }
      	{
      	PAnnotation annotation = new PAnnotation("Surrogate");
      	annotation.addAttribute("feature", "end");
      	addAnnotation(annotation);
      }
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
