package org.eclipse.incquery.viewers.runtime.model.patterns;

import java.util.Arrays;
import java.util.List;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.impl.BasePatternMatch;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.viewers.runtime.model.Item;
import org.eclipse.incquery.viewers.runtime.model.patterns.util.Param2itemQuerySpecification;
import org.eclipse.incquery.viewmodel.traceability.Trace;

/**
 * Pattern-specific match representation of the org.eclipse.incquery.viewers.runtime.model.patterns.param2item pattern,
 * to be used in conjunction with {@link Param2itemMatcher}.
 * 
 * <p>Class fields correspond to parameters of the pattern. Fields with value null are considered unassigned.
 * Each instance is a (possibly partial) substitution of pattern parameters,
 * usable to represent a match of the pattern in the result of a query,
 * or to specify the bound (fixed) input parameters when issuing a query.
 * 
 * @see Param2itemMatcher
 * @see Param2itemProcessor
 * 
 */
@SuppressWarnings("all")
public abstract class Param2itemMatch extends BasePatternMatch {
  private Object fParam;
  
  private Trace fTrace;
  
  private Item fItem;
  
  private static List<String> parameterNames = makeImmutableList("param", "trace", "item");
  
  private Param2itemMatch(final Object pParam, final Trace pTrace, final Item pItem) {
    this.fParam = pParam;
    this.fTrace = pTrace;
    this.fItem = pItem;
  }
  
  @Override
  public Object get(final String parameterName) {
    if ("param".equals(parameterName)) return this.fParam;
    if ("trace".equals(parameterName)) return this.fTrace;
    if ("item".equals(parameterName)) return this.fItem;
    return null;
  }
  
  public Object getParam() {
    return this.fParam;
  }
  
  public Trace getTrace() {
    return this.fTrace;
  }
  
  public Item getItem() {
    return this.fItem;
  }
  
  @Override
  public boolean set(final String parameterName, final Object newValue) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    if ("param".equals(parameterName) && newValue instanceof Object) {
    	this.fParam = (Object) newValue;
    	return true;
    }
    if ("trace".equals(parameterName) ) {
    	this.fTrace = (Trace) newValue;
    	return true;
    }
    if ("item".equals(parameterName) ) {
    	this.fItem = (Item) newValue;
    	return true;
    }
    return false;
  }
  
  public void setParam(final Object pParam) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fParam = pParam;
  }
  
  public void setTrace(final Trace pTrace) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fTrace = pTrace;
  }
  
  public void setItem(final Item pItem) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fItem = pItem;
  }
  
  @Override
  public String patternName() {
    return "org.eclipse.incquery.viewers.runtime.model.patterns.param2item";
  }
  
  @Override
  public List<String> parameterNames() {
    return Param2itemMatch.parameterNames;
  }
  
  @Override
  public Object[] toArray() {
    return new Object[]{fParam, fTrace, fItem};
  }
  
  @Override
  public Param2itemMatch toImmutable() {
    return isMutable() ? newMatch(fParam, fTrace, fItem) : this;
  }
  
  @Override
  public String prettyPrint() {
    StringBuilder result = new StringBuilder();
    result.append("\"param\"=" + prettyPrintValue(fParam) + ", ");
    
    result.append("\"trace\"=" + prettyPrintValue(fTrace) + ", ");
    
    result.append("\"item\"=" + prettyPrintValue(fItem)
    );
    return result.toString();
  }
  
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((fParam == null) ? 0 : fParam.hashCode());
    result = prime * result + ((fTrace == null) ? 0 : fTrace.hashCode());
    result = prime * result + ((fItem == null) ? 0 : fItem.hashCode());
    return result;
  }
  
  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
    	return true;
    if (!(obj instanceof Param2itemMatch)) { // this should be infrequent
    	if (obj == null) {
    		return false;
    	}
    	if (!(obj instanceof IPatternMatch)) {
    		return false;
    	}
    	IPatternMatch otherSig  = (IPatternMatch) obj;
    	if (!specification().equals(otherSig.specification()))
    		return false;
    	return Arrays.deepEquals(toArray(), otherSig.toArray());
    }
    Param2itemMatch other = (Param2itemMatch) obj;
    if (fParam == null) {if (other.fParam != null) return false;}
    else if (!fParam.equals(other.fParam)) return false;
    if (fTrace == null) {if (other.fTrace != null) return false;}
    else if (!fTrace.equals(other.fTrace)) return false;
    if (fItem == null) {if (other.fItem != null) return false;}
    else if (!fItem.equals(other.fItem)) return false;
    return true;
  }
  
  @Override
  public Param2itemQuerySpecification specification() {
    try {
    	return Param2itemQuerySpecification.instance();
    } catch (IncQueryException ex) {
     	// This cannot happen, as the match object can only be instantiated if the query specification exists
     	throw new IllegalStateException (ex);
    }
  }
  
  /**
   * Returns an empty, mutable match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @return the empty match.
   * 
   */
  public static Param2itemMatch newEmptyMatch() {
    return new Mutable(null, null, null);
  }
  
  /**
   * Returns a mutable (partial) match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @param pParam the fixed value of pattern parameter param, or null if not bound.
   * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
   * @param pItem the fixed value of pattern parameter item, or null if not bound.
   * @return the new, mutable (partial) match object.
   * 
   */
  public static Param2itemMatch newMutableMatch(final Object pParam, final Trace pTrace, final Item pItem) {
    return new Mutable(pParam, pTrace, pItem);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pParam the fixed value of pattern parameter param, or null if not bound.
   * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
   * @param pItem the fixed value of pattern parameter item, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public static Param2itemMatch newMatch(final Object pParam, final Trace pTrace, final Item pItem) {
    return new Immutable(pParam, pTrace, pItem);
  }
  
  private static final class Mutable extends Param2itemMatch {
    Mutable(final Object pParam, final Trace pTrace, final Item pItem) {
      super(pParam, pTrace, pItem);
    }
    
    @Override
    public boolean isMutable() {
      return true;
    }
  }
  
  private static final class Immutable extends Param2itemMatch {
    Immutable(final Object pParam, final Trace pTrace, final Item pItem) {
      super(pParam, pTrace, pItem);
    }
    
    @Override
    public boolean isMutable() {
      return false;
    }
  }
}
