/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.model;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;
import org.eclipse.incquery.viewers.runtime.model.ViewerDataFilter;
import org.eclipse.incquery.viewers.runtime.model.ViewerDataModel;
import org.eclipse.incquery.viewers.runtime.model.ViewerState;

public class IncQueryViewerDataModel
extends ViewerDataModel {
    private IncQueryEngine engine;
    private Logger logger;
    private Set<IQuerySpecification<?>> patterns;

    public IncQueryViewerDataModel(Collection<IQuerySpecification<?>> patterns, IncQueryEngine engine) {
        super(engine);
        this.patterns = Sets.newHashSet(patterns);
        this.engine = engine;
        this.logger = IncQueryLoggingUtil.getLogger(this.getClass());
    }

    @Override
    public IncQueryEngine getEngine() {
        return this.engine;
    }

    public Collection<IQuerySpecification<?>> getPatterns(final String annotation) {
        return Collections2.filter(this.patterns, (Predicate)new Predicate<IQuerySpecification<?>>(){

            public boolean apply(IQuerySpecification<?> pattern) {
                return !pattern.getAnnotationsByName(annotation).isEmpty();
            }
        });
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    @Deprecated
    public void dispose() {
    }

    public static ViewerState newViewerState(IncQueryEngine engine, Collection<IQuerySpecification<?>> patterns, ViewerDataFilter filter, Collection<ViewerState.ViewerStateFeature> features) {
        IncQueryViewerDataModel m = new IncQueryViewerDataModel(patterns, engine);
        ViewerState r = IncQueryViewerDataModel.newViewerState(m, filter, features);
        r.hasExternalViewerDataModel = false;
        return r;
    }

    public static ViewerState newViewerState(IncQueryViewerDataModel model, ViewerDataFilter filter, Collection<ViewerState.ViewerStateFeature> features) {
        ViewerState s = new ViewerState(model, filter, features);
        s.hasExternalViewerDataModel = true;
        return s;
    }

    @Override
    public Collection<IQuerySpecification<?>> getPatterns() {
        return this.patterns;
    }
}

