/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.base.itc.igraph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.incquery.runtime.base.itc.igraph.IBiDirectionalGraphDataSource;
import org.eclipse.incquery.runtime.base.itc.igraph.IGraphDataSource;
import org.eclipse.incquery.runtime.base.itc.igraph.IGraphObserver;

public class IBiDirectionalWrapper<V>
implements IBiDirectionalGraphDataSource<V>,
IGraphObserver<V> {
    private static final long serialVersionUID = -5771114630390029106L;
    private IGraphDataSource<V> gds;
    private HashMap<V, ArrayList<V>> backwardEdges;

    public IBiDirectionalWrapper(IGraphDataSource<V> gds) {
        this.gds = gds;
        this.backwardEdges = new HashMap();
        if (gds.getAllNodes() != null) {
            for (V s : gds.getAllNodes()) {
                for (V t : gds.getTargetNodes(s)) {
                    this.edgeInserted(s, t);
                }
            }
        }
        gds.attachObserver(this);
    }

    @Override
    public void attachObserver(IGraphObserver<V> go) {
        this.gds.attachObserver(go);
    }

    @Override
    public void detachObserver(IGraphObserver<V> go) {
        this.gds.detachObserver(go);
    }

    @Override
    public Set<V> getAllNodes() {
        return this.gds.getAllNodes();
    }

    @Override
    public List<V> getTargetNodes(V source) {
        return this.gds.getTargetNodes(source);
    }

    @Override
    public ArrayList<V> getSourceNodes(V target) {
        return this.backwardEdges.get(target);
    }

    @Override
    public void edgeInserted(V source, V target) {
        if (this.backwardEdges.get(target) == null) {
            ArrayList<V> tSet = new ArrayList<V>();
            tSet.add(source);
            this.backwardEdges.put(target, tSet);
        } else {
            this.backwardEdges.get(target).add(source);
        }
    }

    @Override
    public void edgeDeleted(V source, V target) {
        if (this.backwardEdges.containsKey(target)) {
            this.backwardEdges.get(target).remove(source);
            if (this.backwardEdges.get(target).size() == 0) {
                this.backwardEdges.remove(target);
            }
        }
    }

    @Override
    public void nodeInserted(V n) {
    }

    @Override
    public void nodeDeleted(V n) {
        for (V key : this.backwardEdges.keySet()) {
            while (this.backwardEdges.get(key).contains(n)) {
                this.backwardEdges.get(key).remove(n);
            }
        }
    }

    public String toString() {
        return this.gds.toString();
    }
}

