/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.base.core;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.incquery.runtime.base.comprehension.EMFModelComprehension;
import org.eclipse.incquery.runtime.base.comprehension.EMFVisitor;
import org.eclipse.incquery.runtime.base.core.NavigationHelperContentAdapter;
import org.eclipse.incquery.runtime.base.core.NavigationHelperImpl;

public abstract class NavigationHelperVisitor
extends EMFVisitor {
    protected NavigationHelperImpl navigationHelper;
    private final NavigationHelperContentAdapter store;
    boolean isInsertion;
    boolean descendHierarchy;
    boolean traverseOnlyWellBehavingDerivedFeatures;

    NavigationHelperVisitor(NavigationHelperImpl navigationHelper, boolean isInsertion, boolean descendHierarchy) {
        super(isInsertion);
        this.navigationHelper = navigationHelper;
        this.store = navigationHelper.getContentAdapter();
        this.isInsertion = isInsertion;
        this.descendHierarchy = descendHierarchy;
        this.traverseOnlyWellBehavingDerivedFeatures = navigationHelper.getBaseIndexOptions().isTraverseOnlyWellBehavingDerivedFeatures();
    }

    @Override
    public boolean pruneSubtrees(EObject source) {
        return !this.descendHierarchy;
    }

    @Override
    public boolean pruneSubtrees(Resource source) {
        return !this.descendHierarchy;
    }

    @Override
    public boolean pruneFeature(EStructuralFeature feature) {
        if (this.observesFeature(this.toKey(feature))) {
            return false;
        }
        if (feature instanceof EAttribute && this.observesDataType(this.toKey((EClassifier)((EAttribute)feature).getEAttributeType()))) {
            return false;
        }
        return !this.isInsertion || !this.navigationHelper.isExpansionAllowed() || !(feature instanceof EReference) || ((EReference)feature).isContainment();
    }

    protected abstract boolean observesFeature(Object var1);

    protected abstract boolean observesDataType(Object var1);

    protected abstract boolean observesClass(Object var1);

    @Override
    public void visitElement(EObject source) {
        Object classKey;
        EClass eClass = source.eClass();
        if (eClass.eIsProxy()) {
            eClass = (EClass)EcoreUtil.resolve((EObject)eClass, (EObject)source);
        }
        if (this.observesClass(classKey = this.toKey((EClassifier)eClass))) {
            if (this.isInsertion) {
                this.store.insertIntoInstanceSet(classKey, source);
            } else {
                this.store.removeFromInstanceSet(classKey, source);
            }
        }
    }

    @Override
    public void visitAttribute(EObject source, EAttribute feature, Object target) {
        Object featureKey = this.toKey((EStructuralFeature)feature);
        Object eAttributeType = this.toKey((EClassifier)feature.getEAttributeType());
        if (this.observesFeature(featureKey)) {
            if (this.isInsertion) {
                this.store.insertFeatureTuple(featureKey, target, source);
            } else {
                this.store.removeFeatureTuple(featureKey, target, source);
            }
        }
        if (this.observesDataType(eAttributeType)) {
            if (this.isInsertion) {
                this.store.insertIntoDataTypeMap(eAttributeType, target);
            } else {
                this.store.removeFromDataTypeMap(eAttributeType, target);
            }
        }
    }

    @Override
    public void visitInternalContainment(EObject source, EReference feature, EObject target) {
        this.visitReference(source, feature, target);
    }

    @Override
    public void visitNonContainmentReference(EObject source, EReference feature, EObject target) {
        this.visitReference(source, feature, target);
        if (this.isInsertion) {
            this.navigationHelper.considerForExpansion(target);
        }
    }

    private void visitReference(EObject source, EReference feature, EObject target) {
        Object featureKey = this.toKey((EStructuralFeature)feature);
        if (this.observesFeature(featureKey)) {
            if (this.isInsertion) {
                this.store.insertFeatureTuple(featureKey, target, source);
            } else {
                this.store.removeFeatureTuple(featureKey, target, source);
            }
        }
    }

    @Override
    public boolean forceProxyResolution() {
        return this.isInsertion;
    }

    protected Object toKey(EStructuralFeature feature) {
        return this.store.toKey(feature);
    }

    protected Object toKey(EClassifier eClassifier) {
        return this.store.toKey(eClassifier);
    }

    protected boolean isSampledClass(Object eClass) {
        if (!this.traverseOnlyWellBehavingDerivedFeatures) {
            EClass knownClass = (EClass)this.store.getKnownClassifierForKey(eClass);
            for (EStructuralFeature feature : knownClass.getEAllStructuralFeatures()) {
                boolean visitorPrunes;
                EMFModelComprehension comprehension = this.navigationHelper.getComprehension();
                if (comprehension.untraversableDirectly(feature) || (visitorPrunes = this.pruneFeature(feature)) || !comprehension.onlySamplingFeature(feature)) continue;
                this.navigationHelper.registerEClasses((Set<EClass>)ImmutableSet.of((Object)feature.getEContainingClass()));
                return true;
            }
        }
        return false;
    }

    public static class ChangeVisitor
    extends NavigationHelperVisitor {
        private final boolean wildcardMode;
        private final Set<Object> allObservedClasses;
        private final Set<Object> observedDataTypes;
        private final Set<Object> observedFeatures;
        private final Map<Object, Boolean> sampledClasses;

        public ChangeVisitor(NavigationHelperImpl navigationHelper, boolean isInsertion) {
            super(navigationHelper, isInsertion, false);
            this.wildcardMode = navigationHelper.isInWildcardMode();
            this.allObservedClasses = navigationHelper.getAllObservedClassesInternal();
            this.observedDataTypes = navigationHelper.getObservedDataTypesInternal();
            this.observedFeatures = navigationHelper.getObservedFeaturesInternal();
            this.sampledClasses = new HashMap<Object, Boolean>();
        }

        @Override
        protected boolean observesClass(Object eClass) {
            return this.wildcardMode || this.allObservedClasses.contains(eClass) || this.isSampledClassInternal(eClass);
        }

        private boolean isSampledClassInternal(Object eClass) {
            Boolean classAlreadyChecked = this.sampledClasses.get(eClass);
            if (classAlreadyChecked != null) {
                return classAlreadyChecked;
            }
            boolean isSampledClass = this.isSampledClass(eClass);
            this.sampledClasses.put(eClass, isSampledClass);
            return isSampledClass;
        }

        @Override
        protected boolean observesDataType(Object type) {
            return this.wildcardMode || this.observedDataTypes.contains(type);
        }

        @Override
        protected boolean observesFeature(Object feature) {
            return this.wildcardMode || this.observedFeatures.contains(feature);
        }
    }

    public static class TraversingVisitor
    extends NavigationHelperVisitor {
        private final boolean wildcardMode;
        Set<Object> features;
        Set<Object> newClasses;
        Set<Object> oldClasses;
        Map<Object, Boolean> classObservationMap;
        Set<Object> dataTypes;

        public TraversingVisitor(NavigationHelperImpl navigationHelper, Set<Object> features, Set<Object> newClasses, Set<Object> oldClasses, Set<Object> dataTypes) {
            super(navigationHelper, true, true);
            this.wildcardMode = navigationHelper.isInWildcardMode();
            this.features = features;
            this.newClasses = newClasses;
            this.oldClasses = oldClasses;
            this.classObservationMap = new HashMap<Object, Boolean>();
            this.dataTypes = dataTypes;
        }

        @Override
        protected boolean observesClass(Object eClass) {
            if (this.wildcardMode) {
                return true;
            }
            Boolean observed = this.classObservationMap.get(eClass);
            if (observed == null) {
                Set<Object> superTypes = ((NavigationHelperVisitor)this).store.getSuperTypeMap().get(eClass);
                Set<Object> theSuperTypes = superTypes == null ? Collections.emptySet() : superTypes;
                boolean overApprox = this.newClasses.contains(eClass) || this.newClasses.contains(((NavigationHelperVisitor)this).store.getEObjectClassKey()) || !Collections.disjoint(theSuperTypes, this.newClasses);
                observed = overApprox && !this.oldClasses.contains(eClass) && !this.oldClasses.contains(((NavigationHelperVisitor)this).store.getEObjectClassKey()) && Collections.disjoint(theSuperTypes, this.oldClasses);
                if (!observed.booleanValue()) {
                    observed = this.isSampledClass(eClass);
                }
                this.classObservationMap.put(eClass, observed);
            }
            return observed;
        }

        @Override
        protected boolean observesDataType(Object type) {
            return this.wildcardMode || this.dataTypes.contains(type);
        }

        @Override
        protected boolean observesFeature(Object feature) {
            return this.wildcardMode || this.features.contains(feature);
        }
    }
}

