/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.specific.event;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.evm.api.event.EventFilter;

public class IncQuerySinglePatternMatchEventFilter<Match extends IPatternMatch>
implements EventFilter<Match> {
    private Match filterMatch;

    public Match getFilterMatch() {
        return this.filterMatch;
    }

    @Override
    public boolean isProcessable(Match eventAtom) {
        if (this.filterMatch == null) {
            return true;
        }
        return this.filterMatch.isCompatibleWith(eventAtom);
    }

    protected IncQuerySinglePatternMatchEventFilter(Match filterMatch) {
        Preconditions.checkArgument((filterMatch != null ? 1 : 0) != 0, (Object)"Cannot create filter with null match");
        this.filterMatch = filterMatch;
    }

    protected IncQuerySinglePatternMatchEventFilter() {
    }

    public static <Match extends IPatternMatch> IncQuerySinglePatternMatchEventFilter<Match> createFilter(Match eventAtom) {
        Preconditions.checkArgument((eventAtom != null ? 1 : 0) != 0, (Object)"Cannot create filter for null match, use createEmptyFilter() instead!");
        Preconditions.checkArgument((!eventAtom.isMutable() ? 1 : 0) != 0, (Object)"Cannot create filter for mutable match!");
        return new IncQuerySinglePatternMatchEventFilter<Match>(eventAtom);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.filterMatch});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IncQuerySinglePatternMatchEventFilter other = (IncQuerySinglePatternMatchEventFilter)obj;
        return Objects.equal(this.filterMatch, other.filterMatch);
    }
}

