/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.gmf;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.incquery.runtime.api.IModelConnectorTypeEnum;
import org.eclipse.incquery.tooling.ui.queryexplorer.adapters.EMFModelConnector;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.IEditorPart;

public class GMFModelConnector
extends EMFModelConnector {
    public GMFModelConnector(IEditorPart editorPart) {
        super(editorPart);
    }

    public Notifier getNotifier(IModelConnectorTypeEnum modelConnectorTypeEnum) {
        Notifier result = null;
        if (IModelConnectorTypeEnum.RESOURCESET.equals((Object)modelConnectorTypeEnum)) {
            if (this.editorPart instanceof DiagramDocumentEditor) {
                DiagramDocumentEditor diagramDocumentEditor = (DiagramDocumentEditor)this.editorPart;
                return diagramDocumentEditor.getEditingDomain().getResourceSet();
            }
            if (this.editorPart instanceof IDiagramWorkbenchPart) {
                IDiagramWorkbenchPart diagramWorkbenchPart = (IDiagramWorkbenchPart)this.editorPart;
                return diagramWorkbenchPart.getDiagramEditPart().getEditingDomain().getResourceSet();
            }
        } else if (IModelConnectorTypeEnum.RESOURCE.equals((Object)modelConnectorTypeEnum)) {
            if (this.editorPart instanceof DiagramDocumentEditor) {
                DiagramDocumentEditor diagramDocumentEditor = (DiagramDocumentEditor)this.editorPart;
                Diagram diagram = diagramDocumentEditor.getDiagram();
                if (diagram != null && diagram.getElement() != null) {
                    return diagram.getElement().eResource();
                }
                return ((EObject)diagramDocumentEditor.getDiagramEditPart().getModel()).eResource();
            }
            if (this.editorPart instanceof IDiagramWorkbenchPart) {
                IDiagramWorkbenchPart diagramWorkbenchPart = (IDiagramWorkbenchPart)this.editorPart;
                Diagram diagram = diagramWorkbenchPart.getDiagram();
                if (diagram != null && diagram.getElement() != null) {
                    return diagram.getElement().eResource();
                }
                return ((EObject)diagramWorkbenchPart.getDiagramEditPart().getModel()).eResource();
            }
        }
        return result;
    }

    protected TreePath createTreePath(IEditorPart editor, EObject obj) {
        if (editor instanceof DiagramDocumentEditor) {
            DiagramDocumentEditor providerEditor = (DiagramDocumentEditor)editor;
            return this.createTreePath(providerEditor.getDiagramEditPart().getPrimaryChildEditPart(), obj);
        }
        if (editor instanceof IDiagramWorkbenchPart) {
            IDiagramWorkbenchPart dwp = (IDiagramWorkbenchPart)editor;
            return this.createTreePath(dwp.getDiagramEditPart().getPrimaryChildEditPart(), obj);
        }
        return null;
    }

    private TreePath createTreePath(EditPart epBegin, EObject obj) {
        if (epBegin instanceof GraphicalEditPart) {
            ArrayList<EditPart> nodes = new ArrayList<EditPart>();
            if ((epBegin = ((GraphicalEditPart)epBegin).findEditPart((EditPart)epBegin.getRoot(), obj)) != null) {
                nodes.add(epBegin);
                return new TreePath(nodes.toArray());
            }
        }
        return null;
    }

    protected void navigateToElements(IEditorPart editorPart, IStructuredSelection selection) {
        super.navigateToElements(editorPart, selection);
        IDiagramGraphicalViewer viewer = null;
        if (editorPart instanceof DiagramDocumentEditor) {
            DiagramDocumentEditor providerEditor = (DiagramDocumentEditor)editorPart;
            viewer = providerEditor.getDiagramGraphicalViewer();
        } else if (editorPart instanceof IDiagramWorkbenchPart) {
            IDiagramWorkbenchPart dwp = (IDiagramWorkbenchPart)editorPart;
            viewer = dwp.getDiagramGraphicalViewer();
        }
        if (viewer != null && selection.getFirstElement() instanceof GraphicalEditPart) {
            GraphicalEditPart part = (GraphicalEditPart)selection.getFirstElement();
            viewer.reveal((EditPart)part);
        }
    }
}

