/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.construction.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.incquery.runtime.base.api.FunctionalDependencyHelper;
import org.eclipse.incquery.runtime.rete.construction.Buildable;
import org.eclipse.incquery.runtime.rete.construction.Stub;
import org.eclipse.incquery.runtime.rete.construction.psystem.PConstraint;
import org.eclipse.incquery.runtime.rete.construction.psystem.PVariable;
import org.eclipse.incquery.runtime.rete.construction.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.rete.tuple.TupleMask;

public class BuildHelper {
    public static <StubHandle> Stub<StubHandle> enforceVariableCoincidences(Buildable<?, StubHandle, ?> buildable, Stub<StubHandle> stub) {
        Map<Object, List<Integer>> indexWithMupliplicity = stub.getVariablesTuple().invertIndexWithMupliplicity();
        for (Map.Entry<Object, List<Integer>> pVariableIndices : indexWithMupliplicity.entrySet()) {
            List<Integer> indices = pVariableIndices.getValue();
            if (indices.size() <= 1) continue;
            int[] indexArray = new int[indices.size()];
            int m = 0;
            for (Integer index : indices) {
                indexArray[m++] = index;
            }
            stub = buildable.buildEqualityChecker(stub, indexArray);
        }
        return stub;
    }

    public static <StubHandle, Collector> void projectIntoCollector(Buildable<?, StubHandle, Collector> buildable, Stub<StubHandle> stub, Collector collector, PVariable[] selectedVariables) {
        Stub<StubHandle> trimmer = BuildHelper.project(buildable, stub, selectedVariables, false);
        buildable.buildConnection(trimmer, collector);
    }

    public static <StubHandle, Collector> Stub<StubHandle> project(Buildable<?, StubHandle, Collector> buildable, Stub<StubHandle> stub, PVariable[] selectedVariables, boolean enforceUniqueness) {
        int paramNum = selectedVariables.length;
        int[] tI = new int[paramNum];
        int i = 0;
        while (i < paramNum) {
            tI[i] = stub.getVariablesIndex().get(selectedVariables[i]);
            ++i;
        }
        int tiW = stub.getVariablesTuple().getSize();
        TupleMask trim = new TupleMask(tI, tiW);
        Stub<StubHandle> trimmer = buildable.buildTrimmer(stub, trim, enforceUniqueness);
        return trimmer;
    }

    public static <StubHandle> Stub<StubHandle> naturalJoin(Buildable<?, StubHandle, ?> buildable, Stub<StubHandle> primaryStub, Stub<StubHandle> secondaryStub) {
        JoinHelper<StubHandle> joinHelper = new JoinHelper<StubHandle>(primaryStub, secondaryStub);
        return buildable.buildBetaNode(primaryStub, secondaryStub, joinHelper.getPrimaryMask(), joinHelper.getSecondaryMask(), joinHelper.getComplementerMask(), false);
    }

    public static <StubHandle> Stub<StubHandle> trimUnneccessaryVariables(Buildable<?, StubHandle, ?> buildable, Stub<StubHandle> stub, boolean onlyIfNotDetermined) {
        HashSet<PVariable> canBeTrimmed = new HashSet<PVariable>();
        Set variablesInTuple = stub.getVariablesTuple().getDistinctElements();
        for (PVariable trimCandidate : variablesInTuple) {
            if (!trimCandidate.getReferringConstraintsOfType(ExportedParameter.class).isEmpty() || !stub.getAllEnforcedConstraints().containsAll(trimCandidate.getReferringConstraints())) continue;
            canBeTrimmed.add(trimCandidate);
        }
        Set<PVariable> retainedVars = BuildHelper.setMinus(variablesInTuple, canBeTrimmed);
        if (!(canBeTrimmed.isEmpty() || onlyIfNotDetermined && BuildHelper.areVariablesDetermined(stub, retainedVars, canBeTrimmed))) {
            PVariable[] selectedVariablesArray = new ArrayList<PVariable>(retainedVars).toArray(new PVariable[retainedVars.size()]);
            stub = BuildHelper.project(buildable, stub, selectedVariablesArray, true);
        }
        return stub;
    }

    public static <StubHandle> boolean areVariablesDetermined(Stub<StubHandle> stub, Set<PVariable> determining, Set<PVariable> determined) {
        HashMap<Set<PVariable>, Set<PVariable>> dependencies = new HashMap<Set<PVariable>, Set<PVariable>>();
        for (PConstraint pConstraint : stub.getAllEnforcedConstraints()) {
            dependencies.putAll(pConstraint.getFunctionalDependencies());
        }
        Set closure = FunctionalDependencyHelper.closureOf(determining, dependencies);
        boolean isDetermined = closure.containsAll(determined);
        return isDetermined;
    }

    private static <T> Set<T> setMinus(Set<T> a, Set<T> b) {
        HashSet<T> difference = new HashSet<T>(a);
        difference.removeAll(b);
        return difference;
    }

    public static class JoinHelper<StubHandle> {
        private TupleMask primaryMask;
        private TupleMask secondaryMask;
        private TupleMask complementerMask;

        public JoinHelper(Stub<StubHandle> primaryStub, Stub<StubHandle> secondaryStub) {
            Set primaryVariables = primaryStub.getVariablesTuple().getDistinctElements();
            Set secondaryVariables = secondaryStub.getVariablesTuple().getDistinctElements();
            int oldNodes = 0;
            TreeSet<Integer> introducingSecondaryIndices = new TreeSet<Integer>();
            for (PVariable var : secondaryVariables) {
                if (primaryVariables.contains(var)) {
                    ++oldNodes;
                    continue;
                }
                introducingSecondaryIndices.add(secondaryStub.getVariablesIndex().get(var));
            }
            int[] primaryIndices = new int[oldNodes];
            int[] secondaryIndices = new int[oldNodes];
            int k = 0;
            for (PVariable var : secondaryVariables) {
                if (!primaryVariables.contains(var)) continue;
                primaryIndices[k] = primaryStub.getVariablesIndex().get(var);
                secondaryIndices[k] = secondaryStub.getVariablesIndex().get(var);
                ++k;
            }
            int[] complementerIndices = new int[introducingSecondaryIndices.size()];
            int l = 0;
            for (Integer integer : introducingSecondaryIndices) {
                complementerIndices[l++] = integer;
            }
            this.primaryMask = new TupleMask(primaryIndices, primaryStub.getVariablesTuple().getSize());
            this.secondaryMask = new TupleMask(secondaryIndices, secondaryStub.getVariablesTuple().getSize());
            this.complementerMask = new TupleMask(complementerIndices, secondaryStub.getVariablesTuple().getSize());
        }

        public TupleMask getPrimaryMask() {
            return this.primaryMask;
        }

        public TupleMask getSecondaryMask() {
            return this.secondaryMask;
        }

        public TupleMask getComplementerMask() {
            return this.complementerMask;
        }
    }
}

