/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.matcher;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.incquery.runtime.matchers.planning.QueryPlannerException;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.incquery.runtime.matchers.tuple.TupleMask;
import org.eclipse.incquery.runtime.rete.boundary.Disconnectable;
import org.eclipse.incquery.runtime.rete.boundary.IManipulationListener;
import org.eclipse.incquery.runtime.rete.boundary.IPredicateTraceListener;
import org.eclipse.incquery.runtime.rete.boundary.ReteBoundary;
import org.eclipse.incquery.runtime.rete.collections.CollectionsFactory;
import org.eclipse.incquery.runtime.rete.construction.RetePatternBuildException;
import org.eclipse.incquery.runtime.rete.construction.plancompiler.ReteRecipeCompiler;
import org.eclipse.incquery.runtime.rete.index.Indexer;
import org.eclipse.incquery.runtime.rete.index.ProjectionIndexer;
import org.eclipse.incquery.runtime.rete.matcher.IPatternMatcherRuntimeContext;
import org.eclipse.incquery.runtime.rete.matcher.RetePatternMatcher;
import org.eclipse.incquery.runtime.rete.network.Network;
import org.eclipse.incquery.runtime.rete.network.NodeProvisioner;
import org.eclipse.incquery.runtime.rete.traceability.RecipeTraceInfo;

public class ReteEngine {
    protected Network reteNet;
    protected final int reteThreads;
    protected ReteBoundary boundary;
    protected IPatternMatcherRuntimeContext context;
    protected Collection<Disconnectable> disconnectables;
    protected IManipulationListener manipulationListener;
    protected IPredicateTraceListener traceListener;
    protected Map<PQuery, RetePatternMatcher> matchers;
    protected ReteRecipeCompiler compiler;
    protected final boolean parallelExecutionEnabled;
    private boolean disposedOrUninitialized = true;

    public ReteEngine(IPatternMatcherRuntimeContext context, int reteThreads) {
        this.context = context;
        this.reteThreads = reteThreads;
        this.parallelExecutionEnabled = reteThreads > 0;
        this.initEngine();
        this.compiler = null;
    }

    private synchronized void initEngine() {
        this.disposedOrUninitialized = false;
        this.disconnectables = new LinkedList<Disconnectable>();
        this.reteNet = new Network(this.reteThreads, this.context);
        this.boundary = new ReteBoundary(this);
        this.matchers = CollectionsFactory.getMap();
        this.manipulationListener = this.context.subscribePatternMatcherForUpdates(this);
        this.traceListener = this.context.subscribePatternMatcherForTraceInfluences(this);
    }

    private synchronized void deconstructEngine() {
        this.ensureInitialized();
        this.reteNet.kill();
        for (Disconnectable disc : this.disconnectables) {
            disc.disconnect();
        }
        this.matchers = null;
        this.disconnectables = null;
        this.reteNet = null;
        this.boundary = null;
        this.manipulationListener = null;
        this.traceListener = null;
        this.disposedOrUninitialized = true;
    }

    public void killEngine() {
        this.deconstructEngine();
        this.compiler = null;
    }

    public void reset() {
        this.deconstructEngine();
        this.initEngine();
        this.compiler.reset();
    }

    public synchronized RetePatternMatcher accessMatcher(final PQuery gtPattern) throws QueryPlannerException {
        this.ensureInitialized();
        RetePatternMatcher matcher = this.matchers.get(gtPattern);
        if (matcher == null) {
            this.constructionWrapper(new Callable<Void>(){

                @Override
                public Void call() throws QueryPlannerException {
                    RecipeTraceInfo prodNode = ReteEngine.this.boundary.accessProductionTrace(gtPattern);
                    RetePatternMatcher retePatternMatcher = new RetePatternMatcher(ReteEngine.this, prodNode);
                    retePatternMatcher.setTag(gtPattern);
                    ReteEngine.this.matchers.put(gtPattern, retePatternMatcher);
                    return null;
                }
            });
            matcher = this.matchers.get(gtPattern);
        }
        return matcher;
    }

    public synchronized void buildMatchersCoalesced(final Collection<PQuery> specifications) throws QueryPlannerException {
        this.ensureInitialized();
        this.constructionWrapper(new Callable<Void>(){

            @Override
            public Void call() throws QueryPlannerException {
                for (PQuery specification : specifications) {
                    ReteEngine.this.boundary.accessProductionNode(specification);
                }
                return null;
            }
        });
    }

    private void constructionWrapper(Callable<Void> payload) throws RetePatternBuildException {
        this.context.modelReadLock();
        try {
            if (this.parallelExecutionEnabled) {
                this.reteNet.getStructuralChangeLock().lock();
            }
            try {
                try {
                    this.context.coalesceTraversals(payload);
                }
                catch (InvocationTargetException ex) {
                    Throwable cause = ex.getCause();
                    if (cause instanceof RetePatternBuildException) {
                        throw (RetePatternBuildException)((Object)cause);
                    }
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    assert (false);
                }
            }
            finally {
                if (this.parallelExecutionEnabled) {
                    this.reteNet.getStructuralChangeLock().unlock();
                }
                this.reteNet.waitForReteTermination();
            }
        }
        finally {
            this.context.modelReadUnLock();
        }
    }

    synchronized Indexer accessProjection(RecipeTraceInfo production, TupleMask mask) {
        this.ensureInitialized();
        NodeProvisioner nodeProvisioner = this.reteNet.getHeadContainer().getProvisioner();
        ProjectionIndexer result = nodeProvisioner.peekProjectionIndexer(production, mask);
        if (result == null) {
            this.context.modelReadLock();
            try {
                if (this.parallelExecutionEnabled) {
                    this.reteNet.getStructuralChangeLock().lock();
                }
                try {
                    result = nodeProvisioner.accessProjectionIndexerOnetime(production, mask);
                }
                finally {
                    if (this.parallelExecutionEnabled) {
                        this.reteNet.getStructuralChangeLock().unlock();
                    }
                }
            }
            finally {
                this.context.modelReadUnLock();
            }
        }
        return result;
    }

    public void settle() {
        this.ensureInitialized();
        this.reteNet.waitForReteTermination();
    }

    public void settle(Runnable action) {
        this.ensureInitialized();
        this.reteNet.waitForReteTermination(action);
    }

    public Network getReteNet() {
        this.ensureInitialized();
        return this.reteNet;
    }

    public ReteBoundary getBoundary() {
        this.ensureInitialized();
        return this.boundary;
    }

    public void setCompiler(ReteRecipeCompiler builder) {
        this.ensureInitialized();
        this.compiler = builder;
    }

    public IManipulationListener getManipulationListener() {
        this.ensureInitialized();
        return this.manipulationListener;
    }

    public IPredicateTraceListener geTraceListener() {
        this.ensureInitialized();
        return this.traceListener;
    }

    public void addDisconnectable(Disconnectable disc) {
        this.ensureInitialized();
        this.disconnectables.add(disc);
    }

    public boolean isParallelExecutionEnabled() {
        return this.parallelExecutionEnabled;
    }

    public IPatternMatcherRuntimeContext getContext() {
        this.ensureInitialized();
        return this.context;
    }

    public ReteRecipeCompiler getCompiler() {
        this.ensureInitialized();
        return this.compiler;
    }

    void ensureInitialized() {
        if (this.disposedOrUninitialized) {
            throw new IllegalStateException("Trying to use a Rete engine that has been disposed or has not yet been initialized.");
        }
    }
}

