/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.internal.matcherbuilder;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.net.MalformedURLException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.extensibility.IMatchChecker;
import org.eclipse.incquery.runtime.rete.boundary.AbstractEvaluator;
import org.eclipse.incquery.runtime.rete.tuple.Tuple;
import org.eclipse.incquery.runtime.util.CheckExpressionUtil;
import org.eclipse.incquery.runtime.util.ClassLoaderUtil;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.interpreter.IEvaluationContext;
import org.eclipse.xtext.xbase.interpreter.IEvaluationResult;
import org.eclipse.xtext.xbase.interpreter.impl.XbaseInterpreter;

public class XBaseEvaluator
extends AbstractEvaluator {
    @Inject
    private Logger logger;
    private final XExpression xExpression;
    private final Map<String, Integer> tupleNameMap;
    private final Pattern pattern;
    private IMatchChecker matchChecker;
    @Inject
    private XbaseInterpreter interpreter;
    @Inject
    private Provider<IEvaluationContext> contextProvider;
    @Inject
    private IQualifiedNameConverter nameConverter;

    public XBaseEvaluator(XExpression xExpression, Map<String, Integer> tupleNameMapping, Pattern pattern) {
        this.xExpression = xExpression;
        this.tupleNameMap = tupleNameMapping;
        this.pattern = pattern;
    }

    public void init() {
        IConfigurationElement[] configurationElements;
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.incquery.runtime.xexpressionevaluator");
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String id = configurationElement.getAttribute("id");
            if (id.equals(CheckExpressionUtil.getExpressionUniqueID(this.pattern, this.xExpression))) {
                Object object = null;
                try {
                    object = configurationElement.createExecutableExtension("evaluatorClass");
                }
                catch (CoreException coreException) {
                    this.logger.error((Object)"XBase Java evaluator extension point initialization failed.", (Throwable)coreException);
                }
                if (object instanceof IMatchChecker) {
                    this.matchChecker = (IMatchChecker)object;
                }
            }
            ++n2;
        }
        if (this.matchChecker == null) {
            try {
                ClassLoader classLoader = ClassLoaderUtil.getClassLoader(CheckExpressionUtil.getIFile(this.pattern));
                if (classLoader != null) {
                    this.interpreter.setClassLoader(ClassLoaderUtil.getClassLoader(CheckExpressionUtil.getIFile(this.pattern)));
                }
            }
            catch (MalformedURLException malformedURLException) {
                this.logger.error((Object)"XBase Java evaluator extension point initialization failed.", (Throwable)malformedURLException);
            }
            catch (CoreException coreException) {
                this.logger.error((Object)"XBase Java evaluator extension point initialization failed.", (Throwable)coreException);
            }
        }
    }

    public Object doEvaluate(Tuple tuple) throws Throwable {
        this.init();
        if (this.matchChecker != null) {
            return this.matchChecker.evaluateXExpression(tuple, this.tupleNameMap);
        }
        IEvaluationContext context = (IEvaluationContext)this.contextProvider.get();
        for (Map.Entry<String, Integer> entry : this.tupleNameMap.entrySet()) {
            context.newValue(this.nameConverter.toQualifiedName(entry.getKey()), tuple.get(entry.getValue().intValue()));
        }
        IEvaluationResult result = this.interpreter.evaluate(this.xExpression, context, CancelIndicator.NullImpl);
        if (result == null) {
            throw new IncQueryException(String.format("XBase expression interpreter returned no result while evaluating expression %s in pattern %s.", this.xExpression, this.pattern), "XBase expression interpreter returned no result.");
        }
        if (result.getException() != null) {
            throw result.getException();
        }
        return result.getResult();
    }
}

