/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher;

import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.api.AdvancedIncQueryEngine;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryEngineLifecycleListener;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.evm.api.ExecutionSchema;
import org.eclipse.incquery.runtime.evm.api.RuleEngine;
import org.eclipse.incquery.runtime.evm.api.Scheduler;
import org.eclipse.incquery.runtime.evm.specific.ExecutionSchemas;
import org.eclipse.incquery.runtime.evm.specific.Schedulers;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.tooling.ui.IncQueryGUIPlugin;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.CompositeContent;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.ContentChildren;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.PatternMatcherContent;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.PatternMatcherRootContentKey;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.RootContent;
import org.eclipse.incquery.tooling.ui.queryexplorer.util.QueryExplorerPatternRegistry;
import org.eclipse.ui.IEditorPart;

public class PatternMatcherRootContent
extends CompositeContent<RootContent, PatternMatcherContent> {
    private final Map<String, PatternMatcherContent> mapping;
    private ContentChildren<PatternMatcherContent> children;
    private final PatternMatcherRootContentKey key;
    private IncQueryEngineLifecycleListener taintListener;
    private final ILog logger = IncQueryGUIPlugin.getDefault().getLog();
    private IStatus contentStatus;

    public PatternMatcherRootContent(RootContent parent, PatternMatcherRootContentKey key) {
        super(parent);
        this.children = new ContentChildren();
        this.taintListener = new ContentEngineTaintListener();
        this.mapping = Maps.newHashMap();
        this.key = key;
        AdvancedIncQueryEngine engine = key.getEngine();
        if (engine == null) {
            engine = this.createEngine();
            key.setEngine(engine);
            ExecutionSchema ruleEngine = ExecutionSchemas.createIncQueryExecutionSchema((IncQueryEngine)engine, (Scheduler.ISchedulerFactory)Schedulers.getIQEngineSchedulerFactory((IncQueryEngine)engine));
            key.setRuleEngine((RuleEngine)ruleEngine);
            engine.addLifecycleListener(this.taintListener);
        }
    }

    private AdvancedIncQueryEngine createEngine() {
        boolean wildcardMode = IncQueryGUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.incquery.tooling.gui.queryexplorer.WildcardMode");
        boolean dynamicEMFMode = IncQueryGUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.incquery.tooling.gui.queryexplorer.DynamicEMFMode");
        try {
            AdvancedIncQueryEngine engine = AdvancedIncQueryEngine.createUnmanagedEngine((Notifier)this.key.getNotifier(), (boolean)wildcardMode, (boolean)dynamicEMFMode);
            return engine;
        }
        catch (IncQueryException e) {
            this.logger.log((IStatus)new Status(4, "org.eclipse.incquery.tooling.ui", "Could not retrieve IncQueryEngine for " + this.key.getNotifier(), (Throwable)e));
            return null;
        }
    }

    public void registerPattern(final IQuerySpecification<?> ... patterns) {
        AdvancedIncQueryEngine engine = null;
        try {
            engine = this.key.getEngine();
            if (engine.getBaseIndex().isInWildcardMode()) {
                this.addMatchersForPatterns(patterns);
            } else {
                engine.getBaseIndex().coalesceTraversals((Callable)new Callable<Void>(){

                    @Override
                    public Void call() {
                        PatternMatcherRootContent.this.addMatchersForPatterns(patterns);
                        return null;
                    }
                });
            }
            this.contentStatus = Status.OK_STATUS;
        }
        catch (IncQueryException ex) {
            this.reportMatcherError("Cannot initialize pattern matcher engine.", ex);
        }
        catch (InvocationTargetException e) {
            this.reportMatcherError("Error during pattern matcher construction: " + e.getCause().getMessage(), e.getCause());
        }
    }

    private void addMatchersForPatterns(IQuerySpecification<?> ... queries) {
        IQuerySpecification<?>[] iQuerySpecificationArray = queries;
        int n = queries.length;
        int n2 = 0;
        while (n2 < n) {
            IQuerySpecification<?> query = iQuerySpecificationArray[n2];
            boolean isGenerated = QueryExplorerPatternRegistry.getInstance().isGenerated(query);
            this.addMatcher((IncQueryEngine)this.key.getEngine(), this.key.getRuleEngine(), query, isGenerated);
            ++n2;
        }
    }

    public void addMatcher(IncQueryEngine engine, RuleEngine ruleEngine, IQuerySpecification<?> specification, boolean generated) {
        String fqn = specification.getFullyQualifiedName();
        PatternMatcherContent pm = new PatternMatcherContent(this, engine, ruleEngine, specification, generated);
        this.mapping.put(fqn, pm);
        if (generated) {
            this.children.addChild(0, pm);
        } else {
            this.children.addChild(pm);
        }
    }

    public void unregisterPattern(IQuerySpecification<?> specification) {
        this.removeMatcher(specification.getFullyQualifiedName());
    }

    public void removeMatcher(String patternFqn) {
        PatternMatcherContent matcher = this.mapping.get(patternFqn);
        if (matcher != null) {
            matcher.dispose();
            this.children.removeChild(matcher);
            IObservableList observableList = matcher.getChildren();
            if (observableList != null && !observableList.isDisposed()) {
                observableList.dispose();
            }
            this.mapping.remove(patternFqn);
        }
    }

    @Override
    public void dispose() {
        AdvancedIncQueryEngine engine;
        super.dispose();
        RuleEngine ruleEngine = this.key.getRuleEngine();
        if (ruleEngine != null) {
            ruleEngine.dispose();
        }
        if ((engine = this.key.getEngine()) != null) {
            engine.removeLifecycleListener(this.taintListener);
            engine.dispose();
        }
    }

    public boolean isTainted() {
        AdvancedIncQueryEngine engine = this.key.getEngine();
        return engine == null ? true : engine.isTainted();
    }

    public PatternMatcherRootContentKey getKey() {
        return this.key;
    }

    public IEditorPart getEditorPart() {
        return this.key.getEditorPart();
    }

    public Notifier getNotifier() {
        return this.key.getNotifier();
    }

    private void reportMatcherError(String message, Throwable t) {
        this.contentStatus = t != null ? new Status(4, "org.eclipse.incquery.tooling.ui", message, t) : new Status(4, "org.eclipse.incquery.tooling.ui", message);
        this.logger.log(this.contentStatus);
        ((RootContent)this.getParent()).getViewer().refresh((Object)this);
    }

    @Override
    public String getText() {
        return this.key.toString();
    }

    @Override
    public IObservableList getChildren() {
        return this.children;
    }

    @Override
    public Iterator<PatternMatcherContent> getChildrenIterator() {
        return this.children.getElements().iterator();
    }

    public IStatus getStatus() {
        return this.contentStatus;
    }

    private class ContentEngineTaintListener
    implements IncQueryEngineLifecycleListener {
        private ContentEngineTaintListener() {
        }

        public void engineBecameTainted(String description, Throwable t) {
            PatternMatcherRootContent.this.reportMatcherError(description, t);
        }

        public void matcherInstantiated(IncQueryMatcher<? extends IPatternMatch> matcher) {
        }

        public void engineWiped() {
        }

        public void engineDisposed() {
        }
    }
}

