/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.queryexplorer.handlers;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.incquery.runtime.api.AdvancedIncQueryEngine;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.tooling.ui.queryexplorer.QueryExplorer;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.flyout.FlyoutControlComposite;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.PatternMatcherRootContent;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.RootContent;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.patternsviewer.PatternComponent;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.patternsviewer.PatternComposite;
import org.eclipse.incquery.tooling.ui.queryexplorer.util.DisplayUtil;
import org.eclipse.incquery.tooling.ui.queryexplorer.util.QueryExplorerPatternRegistry;

public class RuntimeMatcherRegistrator
implements Runnable {
    private final IFile file;
    private final Resource resource;
    @Inject
    DisplayUtil dbUtil;

    public RuntimeMatcherRegistrator(IFile file, Resource res) {
        this.file = file;
        this.resource = res;
    }

    @Override
    public void run() {
        QueryExplorer queryExplorer = QueryExplorer.getInstance();
        if (queryExplorer != null) {
            try {
                RootContent vr = queryExplorer.getRootContent();
                PatternComposite viewerInput = queryExplorer.getPatternsViewerRoot().getGenericPatternsRoot();
                this.openPatternsViewerIfNoPreviousPatterns(queryExplorer);
                this.unregisterPatternsFromMatcherTreeViewer(vr);
                this.removeLabelsFromPatternRegistry(queryExplorer, viewerInput);
                Set<IQuerySpecification<?>> newPatterns = this.registerPatternsFromPatternModel(vr);
                this.setCheckedStatesOnNewPatterns(queryExplorer, viewerInput, newPatterns);
                queryExplorer.getPatternsViewer().refresh();
                queryExplorer.getPatternsViewerRoot().getGeneratedPatternsRoot().updateHasChildren();
                queryExplorer.getPatternsViewerRoot().getGenericPatternsRoot().updateHasChildren();
            }
            catch (IncQueryException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void setCheckedStatesOnNewPatterns(QueryExplorer queryExplorerInstance, PatternComposite viewerInput, Collection<IQuerySpecification<?>> newSpecifications) {
        ArrayList<PatternComponent> components = new ArrayList<PatternComponent>();
        for (IQuerySpecification<?> specification : newSpecifications) {
            PatternComponent component = viewerInput.addComponent(specification.getFullyQualifiedName());
            components.add(component);
        }
        queryExplorerInstance.getPatternsViewer().refresh();
        for (PatternComponent component : components) {
            component.setCheckedState(true);
        }
    }

    private void removeLabelsFromPatternRegistry(QueryExplorer queryExplorerInstance, PatternComposite viewerInput) {
        List<IQuerySpecification<?>> oldParsedModel = QueryExplorerPatternRegistry.getInstance().getRegisteredPatternsForFile(this.file);
        if (oldParsedModel != null) {
            for (IQuerySpecification<?> pattern : oldParsedModel) {
                viewerInput.removeComponent(pattern.getFullyQualifiedName());
            }
        }
        queryExplorerInstance.getPatternsViewerRoot().getGenericPatternsRoot().purge();
        queryExplorerInstance.getPatternsViewer().refresh();
    }

    private Set<IQuerySpecification<?>> registerPatternsFromPatternModel(RootContent vr) throws IncQueryException {
        PatternModel newParsedModel = null;
        newParsedModel = this.resource != null ? this.dbUtil.extractPatternModelFromResource(this.resource) : this.dbUtil.parseEPM(this.file);
        Set<IQuerySpecification<?>> newPatterns = QueryExplorerPatternRegistry.getInstance().registerPatternModel(this.file, newParsedModel);
        List<IQuerySpecification<?>> allActivePatterns = QueryExplorerPatternRegistry.getInstance().getActivePatterns();
        Iterator<PatternMatcherRootContent> iterator = vr.getChildrenIterator();
        while (iterator.hasNext()) {
            PatternMatcherRootContent root = iterator.next();
            root.registerPattern(allActivePatterns.toArray(new IQuerySpecification[allActivePatterns.size()]));
            root.updateHasChildren();
        }
        return newPatterns;
    }

    private void unregisterPatternsFromMatcherTreeViewer(RootContent vr) {
        List<IQuerySpecification<?>> allActivePatterns = QueryExplorerPatternRegistry.getInstance().getActivePatterns();
        QueryExplorerPatternRegistry.getInstance().unregisterPatternModel(this.file);
        Iterator<PatternMatcherRootContent> iterator = vr.getChildrenIterator();
        while (iterator.hasNext()) {
            PatternMatcherRootContent root = iterator.next();
            for (IQuerySpecification<?> pattern : allActivePatterns) {
                root.unregisterPattern(pattern);
                root.updateHasChildren();
            }
            AdvancedIncQueryEngine engine = root.getKey().getEngine();
            if (engine == null) continue;
            engine.wipe();
        }
    }

    private void openPatternsViewerIfNoPreviousPatterns(QueryExplorer queryExplorerInstance) {
        if (QueryExplorerPatternRegistry.getInstance().isEmpty()) {
            FlyoutControlComposite flyout = queryExplorerInstance.getPatternsViewerFlyout();
            flyout.getPreferences().setState(0);
            flyout.layout();
        }
    }
}

