/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.wizards.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.incquery.tooling.core.targetplatform.ITargetPlatformMetamodelLoader;
import org.eclipse.incquery.tooling.ui.wizards.internal.ElementSelectionDialog;
import org.eclipse.incquery.tooling.ui.wizards.internal.ImportListLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.ui.PlatformUI;

public class ImportListAdapter
implements IListAdapter<String> {
    private ITargetPlatformMetamodelLoader metamodelLoader;

    public ImportListAdapter(ITargetPlatformMetamodelLoader metamodelLoader) {
        this.metamodelLoader = metamodelLoader;
    }

    public void customButtonPressed(ListDialogField<String> field, int index) {
        if (index == 0) {
            ElementSelectionDialog listDialog = new ElementSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), new ImportListLabelProvider(), "EPackage");
            listDialog.setTitle("Select packages to import");
            listDialog.setMessage("Select one or more package(s) (* = any string, ? = any char):");
            Object[] input = this.getElements(field);
            listDialog.setElements(input);
            listDialog.open();
            Object[] result = listDialog.getResult();
            if (result != null && result.length > 0) {
                Object[] objectArray = result;
                int n = result.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    field.addElement((Object)((String)obj));
                    ++n2;
                }
            }
        }
    }

    private Object[] getElements(ListDialogField<String> field) {
        ArrayList<String> result = new ArrayList<String>();
        List packages = this.metamodelLoader.listEPackages();
        for (String ePackage : packages) {
            if (this.fieldContains(field, ePackage)) continue;
            result.add(ePackage);
        }
        return result.toArray();
    }

    private boolean fieldContains(ListDialogField<String> field, String _package) {
        for (String _p : field.getElements()) {
            if (!_p.matches(_package)) continue;
            return true;
        }
        return false;
    }

    public void selectionChanged(ListDialogField<String> field) {
    }

    public void doubleClicked(ListDialogField<String> field) {
    }
}

