package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.ActivityGroupSuperGroupMatch;
import org.eclipse.uml2.uml.ActivityGroup;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.activityGroupSuperGroup pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class ActivityGroupSuperGroupProcessor implements IMatchProcessor<ActivityGroupSuperGroupMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pSource the value of pattern parameter source in the currently processed match
   * @param pTarget the value of pattern parameter target in the currently processed match
   * 
   */
  public abstract void process(final ActivityGroup pSource, final ActivityGroup pTarget);
  
  @Override
  public void process(final ActivityGroupSuperGroupMatch match) {
    process(match.getSource(), match.getTarget());
  }
}
