package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.PackageOwnedTypeMatch;
import org.eclipse.uml2.uml.Type;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.packageOwnedType pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class PackageOwnedTypeProcessor implements IMatchProcessor<PackageOwnedTypeMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pSelf the value of pattern parameter self in the currently processed match
   * @param pTemp2 the value of pattern parameter temp2 in the currently processed match
   * 
   */
  public abstract void process(final org.eclipse.uml2.uml.Package pSelf, final Type pTemp2);
  
  @Override
  public void process(final PackageOwnedTypeMatch match) {
    process(match.getSelf(), match.getTemp2());
  }
}
