package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.ActivityGroupContainedNodeMatch;
import org.eclipse.uml2.uml.ActivityGroup;
import org.eclipse.uml2.uml.ActivityNode;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.activityGroupContainedNode pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class ActivityGroupContainedNodeProcessor implements IMatchProcessor<ActivityGroupContainedNodeMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pSource the value of pattern parameter source in the currently processed match
   * @param pTarget the value of pattern parameter target in the currently processed match
   * 
   */
  public abstract void process(final ActivityGroup pSource, final ActivityNode pTarget);
  
  @Override
  public void process(final ActivityGroupContainedNodeMatch match) {
    process(match.getSource(), match.getTarget());
  }
}
