/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.validation.runtime;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;
import org.eclipse.incquery.validation.runtime.ConstraintAdapter;
import org.eclipse.incquery.validation.runtime.ValidationManager;
import org.eclipse.incquery.validation.runtime.ValidationPartListener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;

public final class ValidationUtil {
    private static Logger logger = IncQueryLoggingUtil.getLogger(ValidationUtil.class);
    private static Map<IWorkbenchPage, Set<IEditorPart>> pageMap = new HashMap<IWorkbenchPage, Set<IEditorPart>>();
    private static Map<IEditorPart, ConstraintAdapter> adapterMap = new HashMap<IEditorPart, ConstraintAdapter>();

    private ValidationUtil() {
    }

    public static synchronized Map<IEditorPart, ConstraintAdapter> getAdapterMap() {
        return adapterMap;
    }

    public static synchronized void addNotifier(IEditorPart editorPart, Notifier notifier) {
        adapterMap.put(editorPart, new ConstraintAdapter(editorPart, notifier, logger));
    }

    public static void registerEditorPart(IEditorPart editorPart) {
        IWorkbenchPage page = editorPart.getSite().getPage();
        if (pageMap.containsKey(page)) {
            pageMap.get(page).add(editorPart);
        } else {
            HashSet<IEditorPart> editorParts = new HashSet<IEditorPart>();
            editorParts.add(editorPart);
            pageMap.put(page, editorParts);
            page.addPartListener((IPartListener)ValidationPartListener.getInstance());
        }
    }

    public static void unregisterEditorPart(IEditorPart editorPart) {
        IWorkbenchPage page = editorPart.getSite().getPage();
        if (pageMap.containsKey(page)) {
            pageMap.get(page).remove(editorPart);
            if (pageMap.get(page).size() == 0) {
                pageMap.remove(page);
                page.removePartListener((IPartListener)ValidationPartListener.getInstance());
            }
        }
    }

    public static boolean isConstraintsRegisteredForEditorId(String editorId) {
        return ValidationManager.isConstraintSpecificationsRegisteredForEditorId(editorId);
    }
}

