/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.model;

import com.google.common.base.Supplier;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.viewers.runtime.model.Containment;
import org.eclipse.incquery.viewers.runtime.model.Edge;
import org.eclipse.incquery.viewers.runtime.model.Item;
import org.eclipse.incquery.viewers.runtime.model.ViewerDataFilter;
import org.eclipse.incquery.viewers.runtime.model.ViewerDataModel;
import org.eclipse.incquery.viewers.runtime.model.ViewerState;
import org.eclipse.incquery.viewers.runtime.model.listeners.IViewerStateListener;

public final class ViewerStateSet
extends ViewerState {
    private IObservableSet itemSet;
    private IObservableSet edgeSet;
    private IObservableSet containmentSet;
    private ISetChangeListener itemListener = new ISetChangeListener(){

        public void handleSetChange(SetChangeEvent event) {
            Object Listener;
            int n;
            int n2;
            Object[] objectArray;
            Item item;
            SetDiff diff = event.diff;
            for (Object entry : diff.getAdditions()) {
                if (!(entry instanceof Item)) continue;
                item = (Item)entry;
                objectArray = ViewerStateSet.this.stateListeners.getListeners();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    Listener = objectArray[n];
                    ((IViewerStateListener)Listener).itemAppeared(item);
                    item.getLabel().addChangeListener(ViewerStateSet.this.labelChangeListener);
                    ++n;
                }
            }
            for (Object entry : diff.getRemovals()) {
                if (!(entry instanceof Item)) continue;
                item = (Item)entry;
                objectArray = ViewerStateSet.this.stateListeners.getListeners();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    Listener = objectArray[n];
                    item.getLabel().removeChangeListener(ViewerStateSet.this.labelChangeListener);
                    ((IViewerStateListener)Listener).itemDisappeared(item);
                    ++n;
                }
            }
        }
    };
    private ISetChangeListener edgeListener = new ISetChangeListener(){

        public void handleSetChange(SetChangeEvent event) {
            Object Listener;
            int n;
            int n2;
            Object[] objectArray;
            Edge edge;
            SetDiff diff = event.diff;
            for (Object entry : diff.getAdditions()) {
                if (!(entry instanceof Edge)) continue;
                edge = (Edge)entry;
                objectArray = ViewerStateSet.this.stateListeners.getListeners();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    Listener = objectArray[n];
                    ((IViewerStateListener)Listener).edgeAppeared(edge);
                    edge.getLabel().addChangeListener(ViewerStateSet.this.labelChangeListener);
                    ++n;
                }
            }
            for (Object entry : diff.getRemovals()) {
                if (!(entry instanceof Edge)) continue;
                edge = (Edge)entry;
                objectArray = ViewerStateSet.this.stateListeners.getListeners();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    Listener = objectArray[n];
                    edge.getLabel().removeChangeListener(ViewerStateSet.this.labelChangeListener);
                    ((IViewerStateListener)Listener).edgeDisappeared(edge);
                    ++n;
                }
            }
        }
    };
    private ISetChangeListener containmentListener = new ISetChangeListener(){

        public void handleSetChange(SetChangeEvent event) {
            Containment edge;
            SetDiff diff = event.diff;
            for (Object entry : diff.getAdditions()) {
                if (!(entry instanceof Containment)) continue;
                edge = (Containment)entry;
                ViewerStateSet.this.containmentAppeared(edge);
            }
            for (Object entry : diff.getRemovals()) {
                if (!(entry instanceof Containment)) continue;
                edge = (Containment)entry;
                ViewerStateSet.this.containmentDisappeared(edge);
            }
        }
    };

    ViewerStateSet(ResourceSet set, IncQueryEngine engine, Collection<Pattern> patterns, ViewerDataFilter filter, Collection<ViewerState.ViewerStateFeature> features) {
        this.model = new ViewerDataModel(set, patterns, engine);
        this.initializeViewerState(this.model, filter, features);
    }

    ViewerStateSet(ViewerDataModel model, ViewerDataFilter filter, Collection<ViewerState.ViewerStateFeature> features) {
        this.model = model;
        this.initializeViewerState(model, filter, features);
    }

    private Multimap<Object, Item> initializeItemMap() {
        HashMap map = Maps.newHashMap();
        return Multimaps.newListMultimap((Map)map, (Supplier)new Supplier<List<Item>>(){

            public List<Item> get() {
                ArrayList list = Lists.newArrayList();
                return new WritableList((List)list, Item.class);
            }
        });
    }

    private void initializeViewerState(ViewerDataModel model, ViewerDataFilter filter, Collection<ViewerState.ViewerStateFeature> features) {
        this.itemMap = this.initializeItemMap();
        this.initializeItemSet(model.initializeObservableItemSet(filter, (Multimap<Object, Item>)this.itemMap));
        for (ViewerState.ViewerStateFeature feature : features) {
            switch (feature) {
                case EDGE: {
                    this.initializeEdgeSet(model.initializeObservableEdgeSet(filter, (Multimap<Object, Item>)this.itemMap));
                    break;
                }
                case CONTAINMENT: {
                    this.initializeContainmentSet(model.initializeObservableContainmentSet(filter, (Multimap<Object, Item>)this.itemMap));
                }
            }
        }
    }

    private IObservableSet getItemSet() {
        return this.itemSet;
    }

    @Override
    public IObservableCollection getItems() {
        return this.getItemSet();
    }

    private void initializeItemSet(IObservableSet itemSet) {
        Item item;
        if (this.itemSet != null) {
            for (Object _item : itemSet) {
                item = (Item)_item;
                item.getLabel().removeChangeListener(this.labelChangeListener);
            }
            this.removeItemListener(itemSet);
        }
        this.itemSet = itemSet;
        this.addItemListener(itemSet);
        for (Object _item : itemSet) {
            item = (Item)_item;
            item.getLabel().addChangeListener(this.labelChangeListener);
        }
    }

    private void addItemListener(IObservableSet containmentSet) {
        containmentSet.addSetChangeListener(this.itemListener);
    }

    private void removeItemListener(IObservableSet oldContainmentSet) {
        oldContainmentSet.removeSetChangeListener(this.itemListener);
    }

    private IObservableSet getEdgeSet() {
        return this.edgeSet;
    }

    @Override
    public IObservableCollection getEdges() {
        return this.getEdgeSet();
    }

    private void initializeEdgeSet(IObservableSet edgeSet) {
        Edge edge;
        if (this.edgeSet != null) {
            this.removeEdgeListener(this.edgeSet);
            for (Object _edge : this.edgeSet) {
                edge = (Edge)_edge;
                edge.getLabel().addChangeListener(this.labelChangeListener);
            }
        }
        this.edgeSet = edgeSet;
        this.addEdgeListener(edgeSet);
        for (Object _edge : edgeSet) {
            edge = (Edge)_edge;
            edge.getLabel().addChangeListener(this.labelChangeListener);
        }
    }

    private void addEdgeListener(IObservableSet edgeSet) {
        edgeSet.addSetChangeListener(this.edgeListener);
    }

    private void removeEdgeListener(IObservableSet oldEdgeSet) {
        oldEdgeSet.removeSetChangeListener(this.edgeListener);
    }

    private IObservableSet getContainmentSet() {
        return this.containmentSet;
    }

    @Override
    public IObservableCollection getContainments() {
        return this.getContainmentSet();
    }

    private void initializeContainmentSet(IObservableSet containmentSet) {
        if (this.containmentSet != null) {
            this.removeContainmentListener(this.containmentSet);
        }
        this.containmentSet = containmentSet;
        this.childrenMap = HashMultimap.create();
        this.parentMap = Maps.newHashMap();
        for (Object obj : containmentSet) {
            Containment containment = (Containment)obj;
            this.containmentAppeared(containment);
        }
        this.addContainmentListener(containmentSet);
    }

    private void containmentAppeared(Containment containment) {
        this.childrenMap.put((Object)containment.getSource(), (Object)containment.getTarget());
        this.parentMap.put(containment.getTarget(), containment.getSource());
        Object[] objectArray = this.stateListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object Listener = objectArray[n2];
            ((IViewerStateListener)Listener).containmentAppeared(containment);
            ++n2;
        }
    }

    private void containmentDisappeared(Containment containment) {
        this.childrenMap.remove((Object)containment.getSource(), (Object)containment.getTarget());
        this.parentMap.remove(containment.getTarget());
        Object[] objectArray = this.stateListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object Listener = objectArray[n2];
            ((IViewerStateListener)Listener).containmentDisappeared(containment);
            ++n2;
        }
    }

    private void addContainmentListener(IObservableSet oldContainmentSet) {
        oldContainmentSet.addSetChangeListener(this.containmentListener);
    }

    private void removeContainmentListener(IObservableSet oldContainmentSet) {
        oldContainmentSet.removeSetChangeListener(this.containmentListener);
    }

    private void checkDanglingEdge(Edge e) {
    }
}

