/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.model;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.incquery.viewers.runtime.model.Containment;
import org.eclipse.incquery.viewers.runtime.model.Edge;
import org.eclipse.incquery.viewers.runtime.model.Item;
import org.eclipse.incquery.viewers.runtime.model.ItemMap;
import org.eclipse.incquery.viewers.runtime.model.ViewerDataFilter;
import org.eclipse.incquery.viewers.runtime.model.ViewerDataModel;
import org.eclipse.incquery.viewers.runtime.model.ViewerState;
import org.eclipse.incquery.viewers.runtime.model.listeners.IViewerStateListener;

public class ViewerStateList
extends ViewerState {
    private IObservableList itemList;
    private IObservableList edgeList;
    private IObservableList containmentList;
    private IListChangeListener itemListener = new IListChangeListener(){

        public void handleListChange(ListChangeEvent event) {
            ListDiff diff = event.diff;
            ListDiffEntry[] listDiffEntryArray = diff.getDifferences();
            int n = listDiffEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener;
                int n3;
                Object[] objectArray;
                ListDiffEntry entry = listDiffEntryArray[n2];
                Item item = (Item)entry.getElement();
                if (entry.isAddition()) {
                    objectArray = ViewerStateList.this.stateListeners.getListeners();
                    n3 = objectArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        listener = objectArray[n4];
                        ((IViewerStateListener)listener).itemAppeared(item);
                        item.getLabel().addChangeListener(ViewerStateList.this.labelChangeListener);
                        ++n4;
                    }
                    for (Edge edge : ViewerStateList.this.edgeDelayer.removeDelayedEdgesForItem(item)) {
                        ViewerStateList.this.handleEdgeAddition(edge);
                    }
                } else {
                    objectArray = ViewerStateList.this.stateListeners.getListeners();
                    n3 = objectArray.length;
                    int n5 = 0;
                    while (n5 < n3) {
                        listener = objectArray[n5];
                        item.getLabel().removeChangeListener(ViewerStateList.this.labelChangeListener);
                        ((IViewerStateListener)listener).itemDisappeared(item);
                        ++n5;
                    }
                }
                ++n2;
            }
        }
    };
    private IListChangeListener edgeListener = new IListChangeListener(){

        public void handleListChange(ListChangeEvent event) {
            ListDiff diff = event.diff;
            ListDiffEntry[] listDiffEntryArray = diff.getDifferences();
            int n = listDiffEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                ListDiffEntry entry = listDiffEntryArray[n2];
                Edge edge = (Edge)entry.getElement();
                boolean existingSource = ViewerStateList.this.itemMap.containsValue((Object)edge.getSource());
                boolean existingTarget = ViewerStateList.this.itemMap.containsValue((Object)edge.getTarget());
                if (existingSource && existingTarget) {
                    if (entry.isAddition()) {
                        ViewerStateList.this.handleEdgeAddition(edge);
                    } else {
                        Object[] objectArray = ViewerStateList.this.stateListeners.getListeners();
                        int n3 = objectArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Object listener = objectArray[n4];
                            edge.getLabel().removeChangeListener(ViewerStateList.this.labelChangeListener);
                            ((IViewerStateListener)listener).edgeDisappeared(edge);
                            ++n4;
                        }
                    }
                } else {
                    ViewerStateList.this.handleEdgeDelay(entry, edge, existingSource, existingTarget);
                }
                ++n2;
            }
        }
    };
    private IListChangeListener containmentListener = new IListChangeListener(){

        public void handleListChange(ListChangeEvent event) {
            ListDiff diff = event.diff;
            ListDiffEntry[] listDiffEntryArray = diff.getDifferences();
            int n = listDiffEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                ListDiffEntry entry = listDiffEntryArray[n2];
                Containment edge = (Containment)entry.getElement();
                boolean existingSource = ViewerStateList.this.itemMap.containsValue((Object)edge.getSource());
                boolean existingTarget = ViewerStateList.this.itemMap.containsValue((Object)edge.getTarget());
                if (existingSource && existingTarget) {
                    if (entry.isAddition()) {
                        ViewerStateList.this.containmentAppeared(edge);
                    } else {
                        ViewerStateList.this.containmentDisappeared(edge);
                    }
                } else {
                    ViewerStateList.this.handleEdgeDelay(entry, edge, existingSource, existingTarget);
                }
                ++n2;
            }
        }
    };

    public ViewerStateList(ViewerDataModel model, ViewerDataFilter filter, Collection<ViewerState.ViewerStateFeature> features) {
        this.model = model;
        this.initializeViewerState(model, filter, features);
    }

    private Multimap<Object, Item> initializeItemMap() {
        return new ItemMap();
    }

    private void handleEdgeDelay(ListDiffEntry entry, Edge edge, boolean existingSource, boolean existingTarget) {
        if (entry.isAddition()) {
            if (!existingSource) {
                this.edgeDelayer.delayEdgeForNonExistingSource(edge);
            }
            if (!existingTarget) {
                this.edgeDelayer.delayEdgeForNonExistingTarget(edge);
            }
        } else {
            if (edge instanceof Containment) {
                this.childrenMap.remove((Object)edge.getSource(), (Object)edge.getTarget());
                this.parentMap.remove(edge.getTarget());
            }
            if (!existingSource) {
                this.edgeDelayer.removeDelayedEdgeForNonExistingSource(edge);
            }
            if (!existingTarget) {
                this.edgeDelayer.removeDelayedEdgeForNonExistingTarget(edge);
            }
        }
    }

    private void handleEdgeAddition(Edge edge) {
        if (edge instanceof Containment) {
            this.containmentAppeared((Containment)edge);
        } else {
            Object[] objectArray = this.stateListeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((IViewerStateListener)listener).edgeAppeared(edge);
                edge.getLabel().addChangeListener(this.labelChangeListener);
                ++n2;
            }
        }
    }

    private void initializeViewerState(ViewerDataModel model, ViewerDataFilter filter, Collection<ViewerState.ViewerStateFeature> features) {
        this.itemMap = this.initializeItemMap();
        this.initializeItemList(model.initializeObservableItemList(filter, (Multimap<Object, Item>)this.itemMap));
        for (ViewerState.ViewerStateFeature feature : features) {
            switch (feature) {
                case EDGE: {
                    this.initializeEdgeList(model.initializeObservableEdgeList(filter, (Multimap<Object, Item>)this.itemMap));
                    break;
                }
                case CONTAINMENT: {
                    this.initializeContainmentList(model.initializeObservableContainmentList(filter, (Multimap<Object, Item>)this.itemMap));
                }
            }
        }
    }

    private IObservableList getItemList() {
        return this.itemList;
    }

    @Override
    public IObservableCollection getItems() {
        return this.getItemList();
    }

    private void initializeItemList(IObservableList itemList) {
        Item item;
        if (this.itemList != null) {
            this.removeItemListener(this.itemList);
            for (Object _item : this.itemList) {
                item = (Item)_item;
                item.getLabel().removeChangeListener(this.labelChangeListener);
            }
        }
        this.itemList = itemList;
        this.addItemListener(itemList);
        for (Object _item : itemList) {
            item = (Item)_item;
            item.getLabel().addChangeListener(this.labelChangeListener);
        }
    }

    private void addItemListener(IObservableList _itemList) {
        _itemList.addListChangeListener(this.itemListener);
    }

    private void removeItemListener(IObservableList _oldItemList) {
        _oldItemList.removeListChangeListener(this.itemListener);
    }

    private IObservableList getEdgeList() {
        return this.edgeList;
    }

    @Override
    public IObservableCollection getEdges() {
        return this.getEdgeList();
    }

    private void initializeEdgeList(IObservableList edgeList) {
        Edge edge;
        if (this.edgeList != null) {
            this.removeEdgeListener(this.edgeList);
            for (Object _edge : edgeList) {
                edge = (Edge)_edge;
                edge.getLabel().removeChangeListener(this.labelChangeListener);
            }
        }
        this.edgeList = edgeList;
        this.addEdgeListener(edgeList);
        for (Object _edge : edgeList) {
            edge = (Edge)_edge;
            edge.getLabel().addChangeListener(this.labelChangeListener);
        }
    }

    private void addEdgeListener(IObservableList edgeList) {
        edgeList.addListChangeListener(this.edgeListener);
    }

    private void removeEdgeListener(IObservableList oldEdgeList) {
        oldEdgeList.removeListChangeListener(this.edgeListener);
    }

    private IObservableList getContainmentList() {
        return this.containmentList;
    }

    @Override
    public IObservableCollection getContainments() {
        return this.getContainmentList();
    }

    private void initializeContainmentList(IObservableList containmentList) {
        if (this.containmentList != null) {
            this.removeContainmentListener(this.containmentList);
        }
        this.containmentList = containmentList;
        this.childrenMap = HashMultimap.create();
        this.parentMap = Maps.newHashMap();
        for (Object obj : containmentList) {
            Containment containment = (Containment)obj;
            this.containmentAppeared(containment);
        }
        this.addContainmentListener(containmentList);
    }

    private void containmentAppeared(Containment containment) {
        this.childrenMap.put((Object)containment.getSource(), (Object)containment.getTarget());
        this.parentMap.put(containment.getTarget(), containment.getSource());
        Object[] objectArray = this.stateListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IViewerStateListener)listener).containmentAppeared(containment);
            ++n2;
        }
    }

    private void containmentDisappeared(Containment containment) {
        this.childrenMap.remove((Object)containment.getSource(), (Object)containment.getTarget());
        this.parentMap.remove(containment.getTarget());
        Object[] objectArray = this.stateListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IViewerStateListener)listener).containmentDisappeared(containment);
            ++n2;
        }
    }

    private void addContainmentListener(IObservableList oldContainmentList) {
        oldContainmentList.addListChangeListener(this.containmentListener);
    }

    private void removeContainmentListener(IObservableList oldContainmentList) {
        oldContainmentList.removeListChangeListener(this.containmentListener);
    }
}

