/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.emf.ui.validation;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.EMFPatternLanguagePackage;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PackageImport;
import org.eclipse.incquery.patternlanguage.emf.validation.EMFPatternLanguageJavaValidator;
import org.eclipse.incquery.tooling.core.generator.genmodel.IEiqGenmodelProvider;
import org.eclipse.incquery.tooling.core.project.ProjectGenerationHelper;
import org.eclipse.xtext.common.types.access.jdt.IJavaProjectProvider;
import org.eclipse.xtext.validation.Check;

public class GenmodelBasedEMFPatternLanguageJavaValidator
extends EMFPatternLanguageJavaValidator {
    @Inject
    private IEiqGenmodelProvider genmodelProvider;
    @Inject
    private IJavaProjectProvider projectProvider;
    @Inject
    private Logger logger;

    @Check
    public void checkImportDependency(PackageImport importDecl) {
        GenModel genmodel;
        Resource res = importDecl.eResource();
        if (this.projectProvider == null || res == null) {
            return;
        }
        IProject project = this.projectProvider.getJavaProject(res.getResourceSet()).getProject();
        GenPackage genPackage = this.genmodelProvider.findGenPackage((EObject)importDecl, importDecl.getEPackage());
        if (genPackage != null && (genmodel = genPackage.getGenModel()) != null) {
            String modelPluginID = genmodel.getModelPluginID();
            try {
                if (modelPluginID != null && !modelPluginID.isEmpty() && !ProjectGenerationHelper.checkBundleDependency((IProject)project, (String)modelPluginID)) {
                    this.error(String.format("To refer elements from the Package %s the bundle %s must be added as dependency", importDecl.getEPackage().getNsURI(), modelPluginID), (EObject)importDecl, (EStructuralFeature)EMFPatternLanguagePackage.Literals.PACKAGE_IMPORT__EPACKAGE, "org.eclipse.incquery.patternlanguage.emf.validation.IssueCodes.missing_import_dependency", new String[]{modelPluginID});
                }
            }
            catch (CoreException e) {
                this.logger.error((Object)"Error while checking the dependencies of the import declaration", (Throwable)e);
            }
        }
    }
}

