/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.matchers.psystem.rewriters;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PDisjunction;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.PDisjunctionRewriter;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.RewriterException;

public class PDisjunctionRewriterCacher
extends PDisjunctionRewriter {
    private final List<PDisjunctionRewriter> rewriterChain;
    private WeakHashMap<PDisjunction, PDisjunction> cachedResults = new WeakHashMap();

    public PDisjunctionRewriterCacher(PDisjunctionRewriter rewriter) {
        this.rewriterChain = ImmutableList.of((Object)rewriter);
    }

    public PDisjunctionRewriterCacher(PDisjunctionRewriter ... rewriters) {
        this.rewriterChain = ImmutableList.copyOf((Object[])rewriters);
    }

    public PDisjunctionRewriterCacher(List<PDisjunctionRewriter> rewriterChain) {
        this.rewriterChain = ImmutableList.copyOf(rewriterChain);
    }

    @Override
    public PDisjunction rewrite(PDisjunction disjunction) throws RewriterException {
        if (!this.cachedResults.containsKey(disjunction)) {
            PDisjunction rewritten = disjunction;
            for (PDisjunctionRewriter rewriter : this.rewriterChain) {
                rewritten = rewriter.rewrite(rewritten);
            }
            this.cachedResults.put(disjunction, rewritten);
        }
        return this.cachedResults.get(disjunction);
    }
}

