/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.eval;

import java.util.Collection;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.incquery.runtime.matchers.backend.IQueryBackend;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.matchers.tuple.TupleMask;
import org.eclipse.incquery.runtime.matchers.util.CollectionsFactory;
import org.eclipse.incquery.runtime.rete.boundary.InputConnector;
import org.eclipse.incquery.runtime.rete.eval.AbstractEvaluator;
import org.eclipse.incquery.runtime.rete.index.MemoryIdentityIndexer;
import org.eclipse.incquery.runtime.rete.index.MemoryNullIndexer;
import org.eclipse.incquery.runtime.rete.index.ProjectionIndexer;
import org.eclipse.incquery.runtime.rete.matcher.ReteEngine;
import org.eclipse.incquery.runtime.rete.network.Direction;
import org.eclipse.incquery.runtime.rete.network.ReteContainer;
import org.eclipse.incquery.runtime.rete.single.SingleInputNode;
import org.eclipse.incquery.runtime.rete.traceability.TraceInfo;

public class PredicateEvaluatorNode
extends SingleInputNode {
    protected ReteEngine engine;
    private Logger logger;
    protected InputConnector inputConnector;
    protected Integer rhsIndex;
    protected int[] affectedIndices;
    protected Set<Tuple> outgoing;
    protected MemoryNullIndexer memoryNullIndexer;
    protected MemoryIdentityIndexer memoryIdentityIndexer;
    protected AbstractEvaluator evaluator;
    private final int tupleWidth;
    private final TupleMask nullMask;
    private final TupleMask identityMask;

    public PredicateEvaluatorNode(ReteEngine engine, ReteContainer container, Integer rhsIndex, int[] affectedIndices, int tupleWidth, AbstractEvaluator evaluator) {
        super(container);
        this.engine = engine;
        this.logger = engine.getLogger();
        this.inputConnector = engine.getReteNet().getInputConnector();
        this.rhsIndex = rhsIndex;
        this.affectedIndices = affectedIndices;
        this.tupleWidth = tupleWidth;
        this.evaluator = evaluator;
        this.outgoing = CollectionsFactory.getSet();
        this.nullMask = TupleMask.linear((int)0, (int)tupleWidth);
        this.identityMask = TupleMask.identity((int)tupleWidth);
    }

    @Override
    public ProjectionIndexer constructIndex(TupleMask mask, TraceInfo ... traces) {
        if (this.nullMask.equals((Object)mask)) {
            MemoryNullIndexer indexer = this.getNullIndexer();
            TraceInfo[] traceInfoArray = traces;
            int n = traces.length;
            int n2 = 0;
            while (n2 < n) {
                TraceInfo traceInfo = traceInfoArray[n2];
                indexer.assignTraceInfo(traceInfo);
                ++n2;
            }
            return indexer;
        }
        if (this.identityMask.equals((Object)mask)) {
            MemoryIdentityIndexer indexer = this.getIdentityIndexer();
            TraceInfo[] traceInfoArray = traces;
            int n = traces.length;
            int n3 = 0;
            while (n3 < n) {
                TraceInfo traceInfo = traceInfoArray[n3];
                indexer.assignTraceInfo(traceInfo);
                ++n3;
            }
            return indexer;
        }
        return super.constructIndex(mask, traces);
    }

    @Override
    public void pullInto(Collection<Tuple> collector) {
        for (Tuple ps : this.outgoing) {
            collector.add(this.inputConnector.wrapTuple(ps));
        }
    }

    @Override
    public void update(Direction direction, Tuple wrappers) {
        Tuple updateElement = this.inputConnector.unwrapTuple(wrappers);
        if (direction == Direction.REVOKE) {
            if (this.outgoing.remove(updateElement)) {
                this.propagateUpdate(Direction.REVOKE, wrappers);
            }
        } else {
            this.check(updateElement);
        }
    }

    protected void check(Tuple ps) {
        boolean result = this.evaluateExpression(ps);
        if (result) {
            if (this.outgoing.add(ps)) {
                this.propagateUpdate(Direction.INSERT, this.inputConnector.wrapTuple(ps));
            }
        } else if (this.outgoing.remove(ps)) {
            this.propagateUpdate(Direction.REVOKE, this.inputConnector.wrapTuple(ps));
        }
    }

    protected boolean evaluateExpression(Tuple ps) {
        Object termResult = this.evaluateTerm(ps);
        if (this.rhsIndex != null) {
            Object rightHandSide = ps.get(this.rhsIndex.intValue());
            return rightHandSide.equals(termResult);
        }
        if (Boolean.FALSE.equals(termResult)) {
            return false;
        }
        if (Boolean.TRUE.equals(termResult)) {
            return true;
        }
        this.logger.warn((Object)String.format("The incremental pattern matcher encountered a type compatibility problem during check() evaluation for pattern(s) %s over variables %s: expression evaluated to type %s instead of java.lang.Boolean. (Developer note: result was %s in %s)", this.getTraceInfoPatternsEnumerated(), this.prettyPrintTuple(ps), termResult == null ? null : termResult.getClass().getName(), termResult, this));
        return false;
    }

    public Object evaluateTerm(Tuple ps) {
        Object result = null;
        try {
            result = this.evaluator.evaluate(ps);
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            this.logger.warn((Object)String.format("The incremental pattern matcher encountered an error during %s evaluation for pattern(s) %s over values %s. Error message: %s. (Developer note: %s in %s)", this.rhsIndex == null ? "check()" : "eval()", this.getTraceInfoPatternsEnumerated(), this.prettyPrintTuple(ps), e.getMessage(), e.getClass().getSimpleName(), this), e);
            result = Boolean.FALSE;
        }
        return result;
    }

    protected String prettyPrintTuple(Tuple ps) {
        return ps.toString();
    }

    @Override
    protected void propagateUpdate(Direction direction, Tuple updateElement) {
        super.propagateUpdate(direction, updateElement);
        if (this.memoryIdentityIndexer != null) {
            this.memoryIdentityIndexer.propagate(direction, updateElement);
        }
        if (this.memoryNullIndexer != null) {
            this.memoryNullIndexer.propagate(direction, updateElement);
        }
    }

    public IQueryBackend getEngine() {
        return this.engine;
    }

    public MemoryNullIndexer getNullIndexer() {
        if (this.memoryNullIndexer == null) {
            this.memoryNullIndexer = new MemoryNullIndexer(this.reteContainer, this.tupleWidth, this.outgoing, this, this);
        }
        return this.memoryNullIndexer;
    }

    public MemoryIdentityIndexer getIdentityIndexer() {
        if (this.memoryIdentityIndexer == null) {
            this.memoryIdentityIndexer = new MemoryIdentityIndexer(this.reteContainer, this.tupleWidth, this.outgoing, this, this);
        }
        return this.memoryIdentityIndexer;
    }
}

