/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.tooling.ui.views;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.incquery.runtime.api.AdvancedIncQueryEngine;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.viewers.runtime.model.IncQueryViewerDataModel;
import org.eclipse.incquery.viewers.runtime.model.ViewerDataFilter;
import org.eclipse.incquery.viewers.runtime.model.ViewerState;
import org.eclipse.incquery.viewers.runtime.model.ViewersAnnotatedPatternTester;
import org.eclipse.incquery.viewers.tooling.ui.Activator;
import org.eclipse.incquery.viewers.tooling.ui.views.tabs.IViewerSandboxTab;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class ViewersSandboxView
extends ViewPart
implements ISelectionProvider {
    public static final String ID = "org.eclipse.incquery.viewers.tooling.ui.sandbox";
    private List<IViewerSandboxTab> tabList;
    private CTabFolder folder;
    private AdvancedIncQueryEngine engine;
    private ViewerState state;

    public static ViewersSandboxView getInstance() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && activeWorkbenchWindow.getActivePage() != null) {
            return (ViewersSandboxView)activeWorkbenchWindow.getActivePage().findView(ID);
        }
        return null;
    }

    public void initializeTabList() {
        IConfigurationElement[] providers;
        this.tabList = Lists.newArrayList();
        IConfigurationElement[] iConfigurationElementArray = providers = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.incquery.viewers.tooling.ui.viewersandboxtab");
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement provider = iConfigurationElementArray[n2];
            try {
                IViewerSandboxTab tab = (IViewerSandboxTab)provider.createExecutableExtension("implementation");
                this.tabList.add(tab);
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.incquery.viewers.tooling.ui", e.getLocalizedMessage(), (Throwable)e));
            }
            ++n2;
        }
    }

    public void createPartControl(Composite parent) {
        this.initializeTabList();
        this.folder = new CTabFolder(parent, 128);
        for (IViewerSandboxTab tab : this.tabList) {
            tab.createPartControl(this.folder);
        }
        this.folder.setSelection(0);
        this.folder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ViewersSandboxView.this.fillToolBar((IViewerSandboxTab)ViewersSandboxView.this.tabList.get(ViewersSandboxView.this.folder.getSelectionIndex()));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ViewersSandboxView.this.fillToolBar((IViewerSandboxTab)ViewersSandboxView.this.tabList.get(ViewersSandboxView.this.folder.getSelectionIndex()));
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this);
    }

    public void setFocus() {
        if (!this.tabList.isEmpty()) {
            this.tabList.get(this.folder.getSelectionIndex()).setFocus();
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IPropertySheetPage.class)) {
            PropertySheetPage propertySheetPage = new PropertySheetPage();
            propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)));
            return propertySheetPage;
        }
        return super.getAdapter(adapter);
    }

    private void fillToolBar(IViewerSandboxTab tab) {
        if (tab != null) {
            IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
            mgr.removeAll();
            for (IContributionItem item : this.getToolbarContributions(tab)) {
                if (item instanceof MenuManager) {
                    IContributionItem[] iContributionItemArray = ((MenuManager)item).getItems();
                    int n = iContributionItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IContributionItem _item = iContributionItemArray[n2];
                        mgr.add(_item);
                        ++n2;
                    }
                    continue;
                }
                mgr.add(item);
            }
            mgr.update(true);
            IMenuManager mmgr = this.getViewSite().getActionBars().getMenuManager();
            mmgr.removeAll();
            for (IContributionItem item : this.getDropdownMenuContributions(tab)) {
                mmgr.add(item);
            }
            mmgr.updateAll(true);
            this.getViewSite().getActionBars().updateActionBars();
        }
    }

    private List<IContributionItem> getDropdownMenuContributions(IViewerSandboxTab tab) {
        ArrayList<IContributionItem> r = new ArrayList<IContributionItem>();
        if (tab != null && tab.getDropDownMenuContributions() != null) {
            r.addAll(tab.getDropDownMenuContributions());
        }
        return r;
    }

    private List<IContributionItem> getToolbarContributions(IViewerSandboxTab tab) {
        ArrayList<IContributionItem> r = new ArrayList<IContributionItem>();
        if (tab != null && tab.getToolBarContributions() != null) {
            r.addAll(tab.getToolBarContributions());
        }
        return r;
    }

    public void setSelection(ISelection selection) {
        for (IViewerSandboxTab tab : this.tabList) {
            tab.setSelection(selection);
        }
    }

    public ISelection getSelection() {
        if (this.folder.getSelectionIndex() != -1) {
            return this.tabList.get(this.folder.getSelectionIndex()).getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        for (IViewerSandboxTab tab : this.tabList) {
            tab.addSelectionChangedListener(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        for (IViewerSandboxTab tab : this.tabList) {
            tab.removeSelectionChangedListener(listener);
        }
    }

    public void setContents(Notifier model, Collection<IQuerySpecification<?>> patterns, ViewerDataFilter filter) throws IncQueryException {
        if (model != null) {
            if (this.state != null) {
                this.state.dispose();
            }
            this.state = IncQueryViewerDataModel.newViewerState((IncQueryEngine)this.getEngine(model), ViewersSandboxView.getPatternsWithProperAnnotations(patterns), (ViewerDataFilter)filter, (Collection)ImmutableSet.of((Object)ViewerState.ViewerStateFeature.EDGE, (Object)ViewerState.ViewerStateFeature.CONTAINMENT));
            for (IViewerSandboxTab tab : this.tabList) {
                tab.bindState(this.state);
            }
        }
    }

    private AdvancedIncQueryEngine getEngine(Notifier model) throws IncQueryException {
        if (this.engine != null) {
            this.engine.dispose();
        }
        this.engine = AdvancedIncQueryEngine.createUnmanagedEngine((Notifier)model, (boolean)false, (boolean)true);
        return this.engine;
    }

    private static Collection<IQuerySpecification<?>> getPatternsWithProperAnnotations(Collection<IQuerySpecification<?>> input) {
        ArrayList res = new ArrayList();
        for (IQuerySpecification<?> p : input) {
            if (!Iterables.any((Iterable)p.getAllAnnotations(), (Predicate)new ViewersAnnotatedPatternTester())) continue;
            res.add(p);
        }
        return res;
    }

    public void dispose() {
        for (IViewerSandboxTab tab : this.tabList) {
            tab.dispose();
        }
        if (this.state != null) {
            this.state.dispose();
        }
        if (this.engine != null) {
            this.engine.dispose();
        }
        super.dispose();
    }
}

