package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.PackageNestingPackageMatch;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.packageNestingPackage pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class PackageNestingPackageProcessor implements IMatchProcessor<PackageNestingPackageMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pNested the value of pattern parameter nested in the currently processed match
   * @param pNesting the value of pattern parameter nesting in the currently processed match
   * 
   */
  public abstract void process(final org.eclipse.uml2.uml.Package pNested, final org.eclipse.uml2.uml.Package pNesting);
  
  @Override
  public void process(final PackageNestingPackageMatch match) {
    process(match.getNested(), match.getNesting());
  }
}
