/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.framework.signature;

import ee.jakarta.tck.data.framework.signature.SigTestResult;
import ee.jakarta.tck.data.framework.signature.SignatureTestDriver;
import ee.jakarta.tck.data.framework.signature.SignatureTestDriverFactory;
import ee.jakarta.tck.data.framework.utilities.TestProperty;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Logger;

public abstract class SigTestEE {
    private static final Logger log = Logger.getLogger(SigTestEE.class.getCanonicalName());
    String[] sVehicles;
    protected SignatureTestDriver driver;

    protected SignatureTestDriver getSigTestDriver() {
        if (this.driver == null) {
            this.driver = SignatureTestDriverFactory.getInstance("sigtest");
        }
        return this.driver;
    }

    protected String getPackageFile() {
        return this.getSigTestDriver().getPackageFileImpl();
    }

    protected String getMapFile() {
        return this.getSigTestDriver().getMapFileImpl();
    }

    protected String getRepositoryDir() {
        return this.getSigTestDriver().getRepositoryDirImpl();
    }

    protected ArrayList<String> getUnlistedOptionalPackages() {
        return null;
    }

    protected abstract String[] getPackages();

    protected String[] getClasses() {
        return new String[0];
    }

    public void setup() {
        try {
            log.info("$$$ SigTestEE.setup() called");
            log.info("$$$ SigTestEE.setup() complete");
        }
        catch (Exception e) {
            log.info("Unexpected exception " + e.getMessage());
        }
    }

    public void signatureTest() throws Fault {
        log.info("$$$ SigTestEE.signatureTest() called");
        SigTestResult results = null;
        String mapFile = this.getMapFile();
        String repositoryDir = this.getRepositoryDir();
        String[] packages = this.getPackages();
        String[] classes = this.getClasses();
        String packageFile = this.getPackageFile();
        String testClasspath = TestProperty.signatureClasspath.getValue();
        String optionalPkgToIgnore = "";
        ArrayList<String> unlistedTechnologyPkgs = this.getUnlistedOptionalPackages();
        Properties sysProps = System.getProperties();
        String version = (String)sysProps.get("java.version");
        if (!version.startsWith("1.")) {
            String jimageDir = TestProperty.signatureImageDir.getValue();
            File f = new File(jimageDir);
            f.mkdirs();
            String javaHome = (String)sysProps.get("java.home");
            log.info("Executing JImage");
            try {
                ProcessBuilder pb = new ProcessBuilder(javaHome + "/bin/jimage", "extract", "--dir=" + jimageDir, javaHome + "/lib/modules");
                System.out.println(javaHome + "/bin/jimage extract --dir=" + jimageDir + " " + javaHome + "/lib/modules");
                pb.redirectErrorStream(true);
                Process proc = pb.start();
                BufferedReader out = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                String line = null;
                while ((line = out.readLine()) != null) {
                    log.info(line);
                }
                int rc = proc.waitFor();
                log.info("JImage RC = " + rc);
                out.close();
            }
            catch (Exception e) {
                log.info("Exception while executing JImage!  Some tests may fail.");
                e.printStackTrace();
            }
        }
        try {
            results = this.getSigTestDriver().executeSigTest(packageFile, mapFile, repositoryDir, packages, classes, testClasspath, unlistedTechnologyPkgs, optionalPkgToIgnore);
            log.info(results.toString());
            if (!results.passed()) {
                log.info("results.passed() returned false");
                throw new Exception();
            }
            log.info("$$$ SigTestEE.signatureTest() returning");
        }
        catch (Exception e) {
            if (results != null && !results.passed()) {
                throw new Fault("SigTestEE.signatureTest() failed!, diffs found");
            }
            log.info("Unexpected exception " + e.getMessage());
            throw new Fault("signatureTest failed with an unexpected exception", e);
        }
    }

    public void cleanup() throws Fault {
        log.info("$$$ SigTestEE.cleanup() called");
        try {
            this.getSigTestDriver().cleanupImpl();
            log.info("$$$ SigTestEE.cleanup() returning");
        }
        catch (Exception e) {
            throw new Fault("Cleanup failed!", e);
        }
    }

    public static class Fault
    extends Exception {
        private static final long serialVersionUID = -1574745208867827913L;
        public Throwable t;

        public Fault(String msg) {
            super(msg);
            log.info(msg);
        }

        public Fault(String msg, Throwable t) {
            super(msg);
            this.t = t;
            log.info(msg);
            t.printStackTrace();
        }

        public Fault(Throwable t) {
            super(t);
            this.t = t;
        }

        @Override
        public void printStackTrace() {
            if (this.t != null) {
                this.t.printStackTrace();
            } else {
                super.printStackTrace();
            }
        }

        @Override
        public void printStackTrace(PrintStream s) {
            if (this.t != null) {
                this.t.printStackTrace(s);
            } else {
                super.printStackTrace(s);
            }
        }

        @Override
        public void printStackTrace(PrintWriter s) {
            if (this.t != null) {
                this.t.printStackTrace(s);
            } else {
                super.printStackTrace(s);
            }
        }

        @Override
        public Throwable getCause() {
            return this.t;
        }

        @Override
        public synchronized Throwable initCause(Throwable cause) {
            if (this.t != null) {
                throw new IllegalStateException("Can't overwrite cause");
            }
            if (!Exception.class.isInstance(cause)) {
                throw new IllegalArgumentException("Cause not permitted");
            }
            this.t = (Exception)cause;
            return this;
        }
    }
}

