/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.Status;
import com.sun.javatest.agent.ActiveAgentPool;
import com.sun.javatest.agent.AgentManager;
import com.sun.javatest.agent.AgentMonitorToolManager;
import com.sun.javatest.agent.Connection;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.util.StringArray;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AgentMonitorTool
extends Tool {
    private AgentManager agentManager = AgentManager.access();
    private ActiveAgentPool activeAgentPool = this.agentManager.getActiveAgentPool();
    private JMenuBar menuBar;
    private AgentPoolSubpanel agentPoolSubpanel;
    private CurrentAgentsSubpanel currAgentsSubpanel;

    AgentMonitorTool(AgentMonitorToolManager m) {
        super(m, "agentMonitor", "agent.window.csh");
        this.setI18NTitle("tool.title");
        this.setShortTitle(this.uif.getI18NString("tool.shortTitle"));
        this.setLayout(new GridBagLayout());
        this.menuBar = new JMenuBar();
        this.menuBar.add(this.uif.createHorizontalGlue("tool.glue"));
        JMenu helpMenu = this.uif.createMenu("tool.help");
        helpMenu.add(this.uif.createHelpMenuItem("tool.help.window", "agent.window.csh"));
        this.menuBar.add(helpMenu);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.agentPoolSubpanel = new AgentPoolSubpanel();
        this.add((Component)this.agentPoolSubpanel, c);
        this.currAgentsSubpanel = new CurrentAgentsSubpanel();
        this.add((Component)this.currAgentsSubpanel, c);
    }

    @Override
    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    @Override
    public void save(Map m) {
        int timeout;
        int port = this.agentPoolSubpanel.getPort();
        if (port != Integer.MIN_VALUE) {
            m.put("port", String.valueOf(port));
        }
        if ((timeout = this.agentPoolSubpanel.getTimeout()) != Integer.MIN_VALUE) {
            m.put("timeout", String.valueOf(timeout));
        }
        m.put("listening", String.valueOf(this.agentPoolSubpanel.isListening()));
    }

    @Override
    protected void restore(Map m) {
        String l = (String)m.get("listening");
        try {
            String t;
            String p = (String)m.get("port");
            if (p != null && p.length() != 0) {
                this.agentPoolSubpanel.setPort(Integer.parseInt(p));
            }
            if ((t = (String)m.get("timeout")) != null && t.length() != 0) {
                this.agentPoolSubpanel.setTimeout(Integer.parseInt(t));
            }
            if (l != null && l.length() != 0) {
                this.agentPoolSubpanel.setListening(l.equals("true"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private class CurrentAgentsSubpanel
    extends JPanel
    implements ListSelectionListener,
    AgentManager.Observer {
        private JList list;
        private DefaultListModel listData;
        private Entry selectedEntry;
        private JLabel addressLabel;
        private JTextField addressField;
        private JLabel tagLabel;
        private JTextField tagField;
        private JLabel requestLabel;
        private JTextField requestField;
        private JLabel execLabel;
        private JTextField execField;
        private JLabel argsLabel;
        private JTextField argsField;
        private JCheckBox localizeArgsCheck;

        CurrentAgentsSubpanel() {
            this.setName("tool.curr");
            this.setBorder(AgentMonitorTool.this.uif.createTitledBorder("tool.curr"));
            this.setLayout(new GridBagLayout());
            AgentMonitorTool.this.uif.setToolTip(this, "tool.curr");
            this.listData = new DefaultListModel();
            this.list = AgentMonitorTool.this.uif.createList("tool.list.curr", this.listData);
            this.list.setVisibleRowCount(5);
            this.list.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object o, int index, boolean isSelected, boolean cellHasFocus) {
                    String name = ((Entry)o).toString();
                    return super.getListCellRendererComponent((JList<?>)list, name, index, isSelected, cellHasFocus);
                }
            });
            this.list.addListSelectionListener(this);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.gridwidth = 0;
            c.insets.bottom = 5;
            c.weightx = 1.0;
            c.weighty = 1.0;
            this.add((Component)AgentMonitorTool.this.uif.createScrollPane(this.list), c);
            GridBagConstraints lc = new GridBagConstraints();
            lc.gridwidth = 1;
            lc.weightx = 0.0;
            lc.anchor = 13;
            lc.insets.right = 5;
            GridBagConstraints fc = new GridBagConstraints();
            fc.gridwidth = 0;
            fc.weightx = 1.0;
            fc.anchor = 17;
            fc.fill = 2;
            this.addressLabel = AgentMonitorTool.this.uif.createLabel("tool.curr.address", true);
            this.add((Component)this.addressLabel, lc);
            this.addressField = AgentMonitorTool.this.uif.createOutputField("tool.curr.address", this.addressLabel);
            this.add((Component)this.addressField, fc);
            this.tagLabel = AgentMonitorTool.this.uif.createLabel("tool.curr.tag", true);
            this.add((Component)this.tagLabel, lc);
            this.tagField = AgentMonitorTool.this.uif.createOutputField("tool.curr.tag", this.tagLabel);
            this.add((Component)this.tagField, fc);
            this.requestLabel = AgentMonitorTool.this.uif.createLabel("tool.curr.request", true);
            this.add((Component)this.requestLabel, lc);
            this.requestField = AgentMonitorTool.this.uif.createOutputField("tool.curr.request", this.requestLabel);
            this.add((Component)this.requestField, fc);
            this.execLabel = AgentMonitorTool.this.uif.createLabel("tool.curr.execute", true);
            this.add((Component)this.execLabel, lc);
            this.execField = AgentMonitorTool.this.uif.createOutputField("tool.curr.execute", this.execLabel);
            this.add((Component)this.execField, fc);
            this.argsLabel = AgentMonitorTool.this.uif.createLabel("tool.curr.args", true);
            this.add((Component)this.argsLabel, lc);
            this.argsField = AgentMonitorTool.this.uif.createOutputField("tool.curr.args", this.argsLabel);
            this.add((Component)this.argsField, fc);
            this.add(AgentMonitorTool.this.uif.createGlue("tool.curr.pad"), lc);
            fc.fill = 3;
            fc.weightx = 0.0;
            fc.anchor = 17;
            this.localizeArgsCheck = AgentMonitorTool.this.uif.createCheckBox("tool.mapArgs", false);
            this.add((Component)this.localizeArgsCheck, fc);
            AgentMonitorTool.this.agentManager.addObserver(this);
        }

        @Override
        public synchronized void valueChanged(ListSelectionEvent ev) {
            Entry e = (Entry)this.list.getSelectedValue();
            if (e == null) {
                this.addressField.setText("");
                this.tagField.setText("");
                this.requestField.setText("");
                this.execField.setText("");
                this.argsField.setText("");
                this.localizeArgsCheck.setSelected(false);
                this.selectedEntry = null;
            } else {
                this.addressField.setText(e.connection.getName());
                this.tagField.setText(e.tag);
                this.requestField.setText(e.request);
                this.execField.setText(e.executable);
                this.argsField.setText(StringArray.join(e.args));
                this.localizeArgsCheck.setSelected(e.localizeArgs);
                this.selectedEntry = e;
            }
        }

        @Override
        public synchronized void started(final Connection c, final String tag, final String request, final String executable, final String[] args, final boolean localizeArgs) {
            if (!EventQueue.isDispatchThread()) {
                Runnable cmd = new Runnable(){

                    @Override
                    public void run() {
                        CurrentAgentsSubpanel.this.started(c, tag, request, executable, args, localizeArgs);
                    }
                };
                EventQueue.invokeLater(cmd);
            } else {
                this.listData.addElement(new Entry(c, tag, request, executable, args, localizeArgs));
            }
        }

        @Override
        public synchronized void finished(final Connection c, final Status status) {
            if (!EventQueue.isDispatchThread()) {
                Runnable cmd = new Runnable(){

                    @Override
                    public void run() {
                        CurrentAgentsSubpanel.this.finished(c, status);
                    }
                };
                EventQueue.invokeLater(cmd);
            } else {
                for (int i = 0; i < this.listData.size(); ++i) {
                    Entry e = (Entry)this.listData.elementAt(i);
                    if (e.connection != c) continue;
                    this.listData.removeElement(e);
                    break;
                }
            }
        }

        private class Entry {
            Connection connection;
            String tag;
            String request;
            String executable;
            String[] args;
            boolean localizeArgs;

            Entry(Connection connection, String tag, String request, String executable, String[] args, boolean localizeArgs) {
                this.connection = connection;
                this.tag = tag;
                this.request = request;
                this.executable = executable;
                this.args = args;
                this.localizeArgs = localizeArgs;
            }

            public String toString() {
                return AgentMonitorTool.this.uif.getI18NString("tool.entry", new Object[]{this.connection.getName(), this.tag});
            }
        }
    }

    private class AgentPoolSubpanel
    extends JPanel
    implements ItemListener,
    ActiveAgentPool.Observer {
        private JCheckBox listeningCheck;
        private JLabel portLabel;
        private JTextField portField;
        private JLabel timeoutLabel;
        private JTextField timeoutField;
        private JList list;
        private DefaultListModel listData;

        AgentPoolSubpanel() {
            this.setName("tool.pool");
            this.setBorder(AgentMonitorTool.this.uif.createTitledBorder("tool.pool"));
            this.setLayout(new GridBagLayout());
            AgentMonitorTool.this.uif.setAccessibleDescription(this, "tool.pool");
            GridBagConstraints lc = new GridBagConstraints();
            GridBagConstraints fc = new GridBagConstraints();
            fc.insets.right = 10;
            this.listeningCheck = AgentMonitorTool.this.uif.createCheckBox("tool.pool.listen", false);
            this.listeningCheck.setSelected(AgentMonitorTool.this.activeAgentPool.isListening());
            this.listeningCheck.addItemListener(this);
            this.add((Component)this.listeningCheck, fc);
            this.portLabel = AgentMonitorTool.this.uif.createLabel("tool.pool.port", true);
            this.add((Component)this.portLabel, lc);
            this.portField = AgentMonitorTool.this.uif.createInputField("tool.pool.port", 6);
            this.portField.setText(String.valueOf(AgentMonitorTool.this.activeAgentPool.getPort()));
            this.add((Component)this.portField, fc);
            this.portLabel.setLabelFor(this.portField);
            this.timeoutLabel = AgentMonitorTool.this.uif.createLabel("tool.pool.timeout", true);
            this.add((Component)this.timeoutLabel, lc);
            this.timeoutField = AgentMonitorTool.this.uif.createInputField("tool.pool.timeout", 6);
            int t = AgentMonitorTool.this.activeAgentPool.getTimeout();
            this.timeoutField.setText(String.valueOf((t + 500) / 1000));
            fc.anchor = 17;
            fc.gridwidth = 0;
            fc.weightx = 1.0;
            this.add((Component)this.timeoutField, fc);
            this.timeoutLabel.setLabelFor(this.timeoutField);
            this.listData = new DefaultListModel();
            this.list = AgentMonitorTool.this.uif.createList("tool.pool", this.listData);
            this.list.setPrototypeCellValue("abcdefghiklmnopqrstuvwxyz");
            this.list.setVisibleRowCount(3);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            this.add((Component)AgentMonitorTool.this.uif.createScrollPane(this.list), c);
            Enumeration e = AgentMonitorTool.this.activeAgentPool.elements();
            while (e.hasMoreElements()) {
                Connection conn = (Connection)e.nextElement();
                this.listData.addElement(conn.getName());
            }
            AgentMonitorTool.this.activeAgentPool.addObserver(this);
            this.enableFields();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void itemStateChanged(ItemEvent e) {
            block23: {
                if (e.getItemSelectable() == this.listeningCheck) {
                    try {
                        if (e.getStateChange() == 1) {
                            try {
                                int timeout = Integer.parseInt(this.timeoutField.getText());
                                if (timeout <= 0) {
                                    throw new NumberFormatException();
                                }
                                AgentMonitorTool.this.activeAgentPool.setTimeout(timeout * 1000);
                            }
                            catch (NumberFormatException ex) {
                                AgentMonitorTool.this.uif.showError("tool.badTimeout");
                                boolean b = AgentMonitorTool.this.activeAgentPool.isListening();
                                if (b != this.listeningCheck.isSelected()) {
                                    this.listeningCheck.setSelected(b);
                                }
                                this.enableFields();
                                return;
                            }
                            try {
                                int port = Integer.parseInt(this.portField.getText());
                                AgentMonitorTool.this.activeAgentPool.setPort(port);
                                if (port < 0) {
                                    throw new NumberFormatException();
                                }
                            }
                            catch (NumberFormatException ex) {
                                AgentMonitorTool.this.uif.showError("tool.badPort");
                                boolean b = AgentMonitorTool.this.activeAgentPool.isListening();
                                if (b != this.listeningCheck.isSelected()) {
                                    this.listeningCheck.setSelected(b);
                                }
                                this.enableFields();
                                return;
                            }
                            try {
                                AgentMonitorTool.this.activeAgentPool.setListening(true);
                                break block23;
                            }
                            catch (IOException ex) {
                                AgentMonitorTool.this.uif.showError("tool.listenOn", ex);
                                boolean b = AgentMonitorTool.this.activeAgentPool.isListening();
                                if (b != this.listeningCheck.isSelected()) {
                                    this.listeningCheck.setSelected(b);
                                }
                                this.enableFields();
                                return;
                            }
                        }
                        try {
                            AgentMonitorTool.this.activeAgentPool.setListening(false);
                        }
                        catch (IOException ex) {
                            AgentMonitorTool.this.uif.showError("tool.listenOff", ex);
                            boolean b = AgentMonitorTool.this.activeAgentPool.isListening();
                            if (b != this.listeningCheck.isSelected()) {
                                this.listeningCheck.setSelected(b);
                            }
                            this.enableFields();
                            return;
                        }
                    }
                    finally {
                        boolean b = AgentMonitorTool.this.activeAgentPool.isListening();
                        if (b != this.listeningCheck.isSelected()) {
                            this.listeningCheck.setSelected(b);
                        }
                        this.enableFields();
                    }
                }
            }
        }

        @Override
        public void addedToPool(final Connection c) {
            if (!EventQueue.isDispatchThread()) {
                Runnable cmd = new Runnable(){

                    @Override
                    public void run() {
                        AgentPoolSubpanel.this.addedToPool(c);
                    }
                };
                EventQueue.invokeLater(cmd);
            } else {
                this.listData.addElement(c.getName());
            }
        }

        @Override
        public void removedFromPool(final Connection c) {
            if (!EventQueue.isDispatchThread()) {
                Runnable cmd = new Runnable(){

                    @Override
                    public void run() {
                        AgentPoolSubpanel.this.removedFromPool(c);
                    }
                };
                EventQueue.invokeLater(cmd);
            } else {
                this.listData.removeElement(c.getName());
            }
        }

        boolean isListening() {
            return this.listeningCheck.isSelected();
        }

        void setListening(boolean b) {
            this.listeningCheck.setSelected(b);
        }

        int getPort() {
            try {
                return Integer.parseInt(this.portField.getText());
            }
            catch (NumberFormatException ex) {
                return Integer.MIN_VALUE;
            }
        }

        void setPort(int port) {
            this.portField.setText(String.valueOf(port));
        }

        int getTimeout() {
            try {
                return Integer.parseInt(this.timeoutField.getText());
            }
            catch (NumberFormatException ex) {
                return Integer.MIN_VALUE;
            }
        }

        void setTimeout(int timeout) {
            this.timeoutField.setText(String.valueOf(timeout));
        }

        private void enableFields() {
            boolean enable = !this.listeningCheck.isSelected();
            this.portLabel.setEnabled(enable);
            this.portField.setEnabled(enable);
            this.timeoutLabel.setEnabled(enable);
            this.timeoutField.setEnabled(enable);
        }
    }
}

