/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.impl.SimpleRange;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.javascript.host.Range;
import com.gargoylesoftware.htmlunit.javascript.host.TextRange;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;

@JsxClass
public class Selection
extends SimpleScriptable {
    private String type_ = "None";

    @Override
    public Object getDefaultValue(Class<?> hint) {
        boolean returnSelectionContent = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECTION_CONTENT_IS_DEFAULT_VALUE);
        if (returnSelectionContent && (String.class.equals(hint) || hint == null)) {
            StringBuilder sb = new StringBuilder();
            for (org.w3c.dom.ranges.Range r : this.getRanges()) {
                sb.append(r.toString());
            }
            return sb.toString();
        }
        return super.getDefaultValue(hint);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public Node getAnchorNode() {
        org.w3c.dom.ranges.Range last = this.getLastRange();
        if (last == null) {
            return null;
        }
        return (Node)this.getScriptableNullSafe(last.getStartContainer());
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public int getAnchorOffset() {
        org.w3c.dom.ranges.Range last = this.getLastRange();
        if (last == null) {
            return 0;
        }
        return last.getStartOffset();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public Node getFocusNode() {
        org.w3c.dom.ranges.Range last = this.getLastRange();
        if (last == null) {
            return null;
        }
        return (Node)this.getScriptableNullSafe(last.getEndContainer());
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public int getFocusOffset() {
        org.w3c.dom.ranges.Range last = this.getLastRange();
        if (last == null) {
            return 0;
        }
        return last.getEndOffset();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public boolean getIsCollapsed() {
        List<org.w3c.dom.ranges.Range> ranges = this.getRanges();
        return ranges.isEmpty() || ranges.size() == 1 && ranges.get(0).getCollapsed();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public int getRangeCount() {
        return this.getRanges().size();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE, maxVersion=9.0f)})
    public String getType() {
        return this.type_;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE, maxVersion=9.0f)})
    public TextRange createRange() {
        org.w3c.dom.ranges.Range first = this.getFirstRange();
        TextRange range = first != null ? new TextRange(first) : new TextRange(new SimpleRange());
        range.setParentScope(this.getParentScope());
        range.setPrototype(this.getPrototype(range.getClass()));
        return range;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public void addRange(Range range) {
        this.getRanges().add(range.toW3C());
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public void removeRange(Range range) {
        this.getRanges().remove(range.toW3C());
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public void removeAllRanges() {
        this.getRanges().clear();
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public Range getRangeAt(int index) {
        List<org.w3c.dom.ranges.Range> ranges = this.getRanges();
        if (index < 0 || index >= ranges.size()) {
            throw Context.reportRuntimeError((String)("Invalid range index: " + index));
        }
        org.w3c.dom.ranges.Range range = ranges.get(index);
        Range jsRange = new Range(range);
        jsRange.setParentScope(this.getWindow());
        jsRange.setPrototype(this.getPrototype(Range.class));
        return jsRange;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public void collapse(Node parentNode, int offset) {
        List<org.w3c.dom.ranges.Range> ranges = this.getRanges();
        ranges.clear();
        ranges.add(new SimpleRange((org.w3c.dom.Node)parentNode.getDomNodeOrDie(), offset));
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public void collapseToEnd() {
        org.w3c.dom.ranges.Range last = this.getLastRange();
        if (last != null) {
            List<org.w3c.dom.ranges.Range> ranges = this.getRanges();
            ranges.clear();
            ranges.add(last);
            last.collapse(false);
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public void collapseToStart() {
        org.w3c.dom.ranges.Range first = this.getFirstRange();
        if (first != null) {
            List<org.w3c.dom.ranges.Range> ranges = this.getRanges();
            ranges.clear();
            ranges.add(first);
            first.collapse(true);
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE, maxVersion=9.0f)})
    public void empty() {
        this.type_ = "None";
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF)})
    public void extend(Node parentNode, int offset) {
        org.w3c.dom.ranges.Range last = this.getLastRange();
        if (last != null) {
            last.setEnd((org.w3c.dom.Node)parentNode.getDomNodeOrDie(), offset);
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public void selectAllChildren(Node parentNode) {
        List<org.w3c.dom.ranges.Range> ranges = this.getRanges();
        ranges.clear();
        ranges.add(new SimpleRange((org.w3c.dom.Node)parentNode.getDomNodeOrDie()));
    }

    private List<org.w3c.dom.ranges.Range> getRanges() {
        HtmlPage page = (HtmlPage)this.getWindow().getDomNodeOrDie();
        return page.getSelectionRanges();
    }

    private org.w3c.dom.ranges.Range getFirstRange() {
        ArrayList<org.w3c.dom.ranges.Range> ranges = new ArrayList<org.w3c.dom.ranges.Range>(this.getRanges());
        org.w3c.dom.ranges.Range first = null;
        for (org.w3c.dom.ranges.Range range : ranges) {
            org.w3c.dom.Node rangeStart;
            if (first == null) {
                first = range;
                continue;
            }
            org.w3c.dom.Node firstStart = first.getStartContainer();
            if ((firstStart.compareDocumentPosition(rangeStart = range.getStartContainer()) & 2) == 0) continue;
            first = range;
        }
        return first;
    }

    private org.w3c.dom.ranges.Range getLastRange() {
        ArrayList<org.w3c.dom.ranges.Range> ranges = new ArrayList<org.w3c.dom.ranges.Range>(this.getRanges());
        org.w3c.dom.ranges.Range last = null;
        for (org.w3c.dom.ranges.Range range : ranges) {
            org.w3c.dom.Node rangeStart;
            if (last == null) {
                last = range;
                continue;
            }
            org.w3c.dom.Node lastStart = last.getStartContainer();
            if ((lastStart.compareDocumentPosition(rangeStart = range.getStartContainer()) & 4) == 0) continue;
            last = range;
        }
        return last;
    }

    private SimpleScriptable getScriptableNullSafe(Object object) {
        SimpleScriptable scriptable = object != null ? this.getScriptableFor(object) : null;
        return scriptable;
    }
}

