/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.cmd.controller.intern;

import java.rmi.AlreadyBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import org.eclipse.jubula.client.cmd.controller.IClcServer;

public class RmiBase {
    private int m_portNumber;
    private Registry m_registry;
    private IClcServer m_clcServerImpl;

    public RmiBase(int portNumber, IClcServer service) {
        this.m_portNumber = portNumber;
        try {
            this.m_registry = LocateRegistry.createRegistry(this.m_portNumber);
            this.registerServices(service);
        }
        catch (RemoteException e) {
            throw new IllegalArgumentException("Can't create RMI registry on port " + this.m_portNumber, e);
        }
        catch (AlreadyBoundException e) {
            throw new IllegalStateException("Can't bind service", e);
        }
    }

    private void registerServices(IClcServer service) throws RemoteException, AlreadyBoundException {
        this.m_clcServerImpl = service;
        IClcServer clcServerStub = (IClcServer)UnicastRemoteObject.exportObject((Remote)this.m_clcServerImpl, 0);
        this.m_registry.bind("ClcService", clcServerStub);
    }

    public Registry getRegistry() {
        return this.m_registry;
    }
}

